/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.image.FormatFinder;
import org.apache.sis.internal.storage.image.WorldFileResource;
import org.apache.sis.internal.storage.image.WorldFileStore;
import org.apache.sis.internal.storage.image.WritableResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.opengis.geometry.Envelope;

class SingleImageStore
extends WorldFileStore
implements GridCoverageResource {
    private volatile WorldFileResource delegate;

    SingleImageStore(FormatFinder formatFinder) throws DataStoreException, IOException {
        super(formatFinder, false);
    }

    @Override
    final boolean isComponentHidden() {
        return true;
    }

    final WorldFileResource delegate() throws DataStoreException {
        WorldFileResource worldFileResource = this.delegate;
        if (worldFileResource == null) {
            this.delegate = worldFileResource = ((WorldFileStore.Components)((Object)this.components())).get(0);
        }
        return worldFileResource;
    }

    @Override
    public final GridGeometry getGridGeometry() throws DataStoreException {
        return this.delegate().getGridGeometry();
    }

    @Override
    public final Optional<Envelope> getEnvelope() throws DataStoreException {
        return this.delegate().getEnvelope();
    }

    @Override
    public final List<double[]> getResolutions() throws DataStoreException {
        return this.delegate().getResolutions();
    }

    @Override
    public final List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.delegate().getSampleDimensions();
    }

    @Override
    public final GridCoverageResource subset(Query query) throws UnsupportedQueryException, DataStoreException {
        return this.delegate().subset(query);
    }

    @Override
    public final GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        return this.delegate().read(gridGeometry, nArray);
    }

    @Override
    public final RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return this.delegate().getLoadingStrategy();
    }

    @Override
    public final boolean setLoadingStrategy(RasterLoadingStrategy rasterLoadingStrategy) throws DataStoreException {
        return this.delegate().setLoadingStrategy(rasterLoadingStrategy);
    }

    static final class Writable
    extends SingleImageStore
    implements WritableGridCoverageResource {
        Writable(FormatFinder formatFinder) throws DataStoreException, IOException {
            super(formatFinder);
        }

        @Override
        public void write(GridCoverage gridCoverage, WritableGridCoverageResource.Option ... optionArray) throws DataStoreException {
            ((WritableResource)this.delegate()).write(gridCoverage, optionArray);
        }
    }
}

