/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.security.PrivilegedAction;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainerClassLoader;
import org.exoplatform.container.PortalContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.UnifiedClassLoader;
import org.exoplatform.container.WebAppInitContext;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.security.ContainerPermissions;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;

@Managed
@NamingContext(value={@Property(key="portal", value="{Name}")})
@NameTemplate(value={@Property(key="container", value="portal"), @Property(key="name", value="{Name}")})
@RESTEndpoint(path="pcontainer")
public class PortalContainer
extends ExoContainer {
    private static final long serialVersionUID = -9110532469581690803L;
    public static String DEFAULT_PORTAL_CONTAINER_NAME;
    public static String DEFAULT_REST_CONTEXT_NAME;
    public static String DEFAULT_REALM_NAME;
    private static PortalContainerConfig CONFIG;
    private volatile boolean started_;
    private volatile boolean initialized_;
    private PortalContainerInfo pinfo_;
    private final String name;
    private final Comparator<WebAppInitContext> webAppComparator;
    private final ServletContext portalMergedContext;
    private final ClassLoader portalMergedClassLoader;
    private volatile Set<WebAppInitContext> webAppContexts;
    private volatile Map<String, ClassLoader> webAppClassLoaders;
    final ServletContext portalContext;

    public PortalContainer(RootContainer parent, final ServletContext portalContext) {
        super(parent);
        this.name = ContainerUtil.getServletContextName(portalContext);
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PortalContainer.this.context.setName(PortalContainer.this.name);
                return null;
            }
        });
        this.pinfo_ = new PortalContainerInfo(portalContext);
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PortalContainer.this.registerComponentInstance(ServletContext.class, portalContext);
                PortalContainer.this.registerComponentInstance(PortalContainerInfo.class, PortalContainer.this.pinfo_);
                return null;
            }
        });
        PortalContainerConfig config = parent.getPortalContainerConfig();
        List<String> dependencies = config == null ? null : config.getDependencies(this.name);
        this.webAppComparator = dependencies == null || dependencies.isEmpty() ? null : new WebAppInitContextComparator(dependencies);
        this.webAppContexts = Collections.singleton(new WebAppInitContext(portalContext));
        this.portalContext = portalContext;
        this.portalMergedContext = new PortalContainerContext(this);
        this.portalMergedClassLoader = (ClassLoader)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new PortalContainerClassLoader(PortalContainer.this);
            }
        });
        this.webAppClassLoaders = Collections.unmodifiableMap(Collections.singletonMap(this.name, this.portalMergedClassLoader));
    }

    Set<WebAppInitContext> getWebAppInitContexts() {
        return this.webAppContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getWebAppClassLoader(ServletContext context) {
        String contextName = ContainerUtil.getServletContextName(context);
        ClassLoader cl = this.webAppClassLoaders.get(contextName);
        if (cl == null) {
            PortalContainer portalContainer = this;
            synchronized (portalContainer) {
                cl = this.webAppClassLoaders.get(contextName);
                if (cl == null) {
                    cl = UnifiedClassLoader.createUnifiedClassLoaderInPrivilegedMode(Thread.currentThread().getContextClassLoader(), this.portalMergedClassLoader);
                    HashMap<String, ClassLoader> cls = new HashMap<String, ClassLoader>(this.webAppClassLoaders);
                    cls.put(contextName, cl);
                    this.webAppClassLoaders = Collections.unmodifiableMap(cls);
                }
            }
        }
        return cl;
    }

    public ClassLoader getPortalClassLoader() {
        return this.portalMergedClassLoader;
    }

    public ServletContext getPortalContext() {
        return this.portalMergedContext;
    }

    public synchronized void registerContext(ServletContext context) {
        WebAppInitContext webappCtx;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (!this.webAppContexts.contains(webappCtx = new WebAppInitContext(context))) {
            AbstractSet contexts;
            if (this.webAppComparator == null) {
                contexts = new HashSet<WebAppInitContext>(this.webAppContexts);
            } else {
                contexts = new TreeSet<WebAppInitContext>(this.webAppComparator);
                contexts.addAll(this.webAppContexts);
            }
            contexts.add((WebAppInitContext)webappCtx);
            this.webAppContexts = Collections.unmodifiableSet(contexts);
        }
    }

    public synchronized void unregisterContext(ServletContext context) {
        WebAppInitContext webappCtx;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (this.webAppContexts.contains(webappCtx = new WebAppInitContext(context))) {
            AbstractSet contexts;
            if (this.webAppComparator == null) {
                contexts = new HashSet<WebAppInitContext>(this.webAppContexts);
            } else {
                contexts = new TreeSet<WebAppInitContext>(this.webAppComparator);
                contexts.addAll(this.webAppContexts);
            }
            contexts.remove(webappCtx);
            this.webAppContexts = Collections.unmodifiableSet(contexts);
        }
    }

    @Managed
    @ManagedDescription(value="The portal container name")
    public String getName() {
        return this.name;
    }

    @Managed
    @ManagedDescription(value="The configuration of the container in XML format.")
    public String getConfigurationXML() {
        Configuration conf = this.getConfiguration();
        if (conf == null) {
            LOG.warn((Object)"The configuration of the PortalContainer could not be found");
            return null;
        }
        Configuration result = Configuration.merge(this.parent.getConfiguration(), conf);
        if (result == null) {
            LOG.warn((Object)"The configurations could not be merged");
            return null;
        }
        return result.toXML();
    }

    public PortalContainerInfo getPortalContainerInfo() {
        return this.pinfo_;
    }

    public static PortalContainer getInstance() {
        PortalContainer container = PortalContainer.getInstanceIfPresent();
        if (container == null) {
            final PortalContainer currentPortalContainer = container = RootContainer.getInstance().getPortalContainer(DEFAULT_PORTAL_CONTAINER_NAME);
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PortalContainer.setInstance(currentPortalContainer);
                    return null;
                }
            });
        }
        return container;
    }

    public static PortalContainer getInstanceIfPresent() {
        ExoContainer container = ExoContainerContext.getCurrentContainerIfPresent();
        if (container instanceof PortalContainer) {
            return (PortalContainer)container;
        }
        return null;
    }

    public static boolean isPortalContainerName(String name) {
        if (CONFIG == null) {
            return DEFAULT_PORTAL_CONTAINER_NAME.equals(name);
        }
        return CONFIG.isPortalContainerName(name);
    }

    public static boolean isPortalContainerNameDisabled(String name) {
        if (CONFIG == null) {
            return false;
        }
        return CONFIG.isPortalContainerNameDisabled(name);
    }

    public static void addInitTask(ServletContext context, RootContainer.PortalContainerInitTask task) {
        PortalContainer.addInitTask(context, task, null);
    }

    public static void addInitTask(ServletContext context, RootContainer.PortalContainerInitTask task, String portalContainerName) {
        if (context == null || CONFIG == null) {
            return;
        }
        String contextName = ContainerUtil.getServletContextName(context);
        List<String> portalContainerNames = CONFIG.getPortalContainerNames(contextName);
        RootContainer root = RootContainer.getInstance();
        for (String name : portalContainerNames) {
            if (portalContainerName != null && !portalContainerName.equals(name)) continue;
            root.addInitTask(context, task, name);
        }
    }

    public static PortalContainer getInstance(ServletContext context) {
        if (context == null || CONFIG == null) {
            return null;
        }
        String portalContainerName = CONFIG.getPortalContainerName(ContainerUtil.getServletContextName(context));
        if (portalContainerName == null) {
            if (PropertyManager.isDevelopping()) {
                LOG.warn((Object)("The Servlet Context '" + ContainerUtil.getServletContextName(context) + "' has not been registered has a dependency of any PortalContainerDefinitions."));
            }
            return null;
        }
        RootContainer root = RootContainer.getInstance();
        return root.getPortalContainer(portalContainerName);
    }

    public static PortalContainer getCurrentInstance(ServletContext context) {
        PortalContainer container = PortalContainer.getInstanceIfPresent();
        if (container == null) {
            return PortalContainer.getInstance(context);
        }
        return container;
    }

    public static String getCurrentPortalContainerName() {
        PortalContainer container = PortalContainer.getInstanceIfPresent();
        if (container == null) {
            return DEFAULT_PORTAL_CONTAINER_NAME;
        }
        return container.getName();
    }

    public static String getCurrentRestContextName() {
        String containerName = PortalContainer.getCurrentPortalContainerName();
        return PortalContainer.getRestContextName(containerName);
    }

    public static String getRestContextName(String portalContainerName) {
        if (CONFIG == null) {
            return DEFAULT_REST_CONTEXT_NAME;
        }
        return CONFIG.getRestContextName(portalContainerName);
    }

    public String getRestContextName() {
        return PortalContainer.getRestContextName(this.getName());
    }

    public static String getCurrentRealmName() {
        String containerName = PortalContainer.getCurrentPortalContainerName();
        return PortalContainer.getRealmName(containerName);
    }

    public static String getRealmName(String portalContainerName) {
        if (CONFIG == null) {
            return DEFAULT_REALM_NAME;
        }
        return CONFIG.getRealmName(portalContainerName);
    }

    public String getRealmName() {
        return PortalContainer.getRealmName(this.getName());
    }

    public static Object getCurrentSetting(String settingName) {
        String containerName = PortalContainer.getCurrentPortalContainerName();
        return PortalContainer.getSetting(containerName, settingName);
    }

    public static Object getSetting(String portalContainerName, String settingName) {
        if (CONFIG == null) {
            return null;
        }
        return CONFIG.getSetting(portalContainerName, settingName);
    }

    public Object getSetting(String settingName) {
        return PortalContainer.getSetting(this.getName(), settingName);
    }

    public static boolean isScopeValid(PortalContainer container, ServletContext context) {
        if (CONFIG == null) {
            return true;
        }
        return CONFIG.isScopeValid(container.getName(), ContainerUtil.getServletContextName(context));
    }

    @Managed
    public boolean isStarted() {
        return this.started_;
    }

    @Override
    public void start() {
        if (this.initialized_) {
            super.start();
        } else {
            this.initialized_ = true;
            super.start(true);
        }
        this.started_ = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.started_ = false;
    }

    public static void setInstance(PortalContainer instance) {
        ExoContainerContext.setCurrentContainer(instance);
    }

    public static Object getComponent(Class<?> key) {
        PortalContainer pcontainer = PortalContainer.getInstanceIfPresent();
        return pcontainer.getComponentInstanceOfType(key);
    }

    static void reloadConfig() {
        ExoContainer top = ExoContainerContext.getTopContainer();
        PortalContainerConfig portalContainerConfig = CONFIG = top instanceof RootContainer ? ((RootContainer)top).getPortalContainerConfig() : null;
        if (CONFIG == null) {
            DEFAULT_PORTAL_CONTAINER_NAME = PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME;
            DEFAULT_REST_CONTEXT_NAME = PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME;
            DEFAULT_REALM_NAME = PortalContainerConfig.DEFAULT_REALM_NAME;
        } else {
            DEFAULT_PORTAL_CONTAINER_NAME = CONFIG.getDefaultPortalContainer();
            DEFAULT_REST_CONTEXT_NAME = CONFIG.getDefaultRestContext();
            DEFAULT_REALM_NAME = CONFIG.getDefaultRealmName();
        }
    }

    static {
        PortalContainer.reloadConfig();
    }

    static class WebAppInitContextComparator
    implements Comparator<WebAppInitContext> {
        private final List<String> dependencies;

        WebAppInitContextComparator(List<String> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public int compare(WebAppInitContext ctx1, WebAppInitContext ctx2) {
            int idx1 = this.dependencies.indexOf(ctx1.getServletContextName());
            int idx2 = this.dependencies.indexOf(ctx2.getServletContextName());
            if (idx1 == -1 && idx2 != -1) {
                return 1;
            }
            if (idx1 != -1 && idx2 == -1) {
                return -1;
            }
            if (idx1 == -1 && idx2 == -1) {
                return ctx1.getServletContextName().compareTo(ctx2.getServletContextName());
            }
            return idx1 - idx2;
        }
    }

    public static class UnregisterTask
    extends RootContainer.PortalContainerPostInitTask {
        @Override
        public void execute(ServletContext context, PortalContainer portalContainer) {
            portalContainer.unregisterContext(context);
        }
    }

    public static class RegisterTask
    extends RootContainer.PortalContainerPreInitTask {
        @Override
        public void execute(ServletContext context, PortalContainer portalContainer) {
            portalContainer.registerContext(context);
        }
    }
}

