/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop;

import java.io.Serializable;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageKey;

public final class SiteKey
implements Serializable {
    private final SiteType type;
    private final String name;

    public static SiteKey portal(String name) {
        return new SiteKey(SiteType.PORTAL, name);
    }

    public static SiteKey group(String name) {
        return new SiteKey(SiteType.GROUP, name);
    }

    public static SiteKey user(String name) {
        return new SiteKey(SiteType.USER, name);
    }

    public static SiteKey space(String name) {
        return new SiteKey(SiteType.SPACE, name);
    }

    public SiteKey(SiteType type, String name) {
        if (type == null) {
            throw new NullPointerException("No null type can be provided");
        }
        if (name == null) {
            throw new NullPointerException("No null name can be provided");
        }
        this.type = type;
        this.name = name;
    }

    public SiteKey(String type, String name) {
        if (PortalConfig.PORTAL_TYPE.equalsIgnoreCase(type)) {
            this.type = SiteType.PORTAL;
        } else if (PortalConfig.GROUP_TYPE.equalsIgnoreCase(type)) {
            this.type = SiteType.GROUP;
        } else if (PortalConfig.SPACE_TYPE.equalsIgnoreCase(type)) {
            this.type = SiteType.SPACE;
        } else if (PortalConfig.USER_TYPE.equalsIgnoreCase(type)) {
            this.type = SiteType.USER;
        } else {
            throw new NullPointerException("No null name can be provided");
        }
        this.name = name;
    }

    public SiteType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public String getName() {
        return this.name;
    }

    public PageKey page(String name) {
        return new PageKey(this, name);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass().equals(obj.getClass())) {
            SiteKey that = (SiteKey)obj;
            return this.type.getName().equals(that.type.getName()) && this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        return "SiteKey[type=" + this.type.toString() + ",name=" + this.name + "]";
    }
}

