/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Attachment;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.PermissionEntry;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;

public interface DataStorage {
    public Wiki getWikiByTypeAndOwner(String var1, String var2) throws WikiException;

    public List<Wiki> getWikisByType(String var1) throws WikiException;

    public Wiki createWiki(Wiki var1) throws WikiException;

    public Page createPage(Wiki var1, Page var2, Page var3) throws WikiException;

    public Page getPageOfWikiByName(String var1, String var2, String var3) throws WikiException;

    public Page getPageById(String var1) throws WikiException;

    public DraftPage getDraftPageById(String var1) throws WikiException;

    public Page getParentPageOf(Page var1) throws WikiException;

    public List<Page> getChildrenPageOf(Page var1, String var2, boolean var3) throws WikiException;

    public boolean hasChildren(long var1);

    public boolean hasDrafts(long var1);

    public void deletePage(String var1, String var2, String var3) throws WikiException;

    public void deleteDraftOfPage(Page var1, String var2) throws WikiException;

    public void deleteDraftOfPage(Page var1, String var2, String var3) throws WikiException;

    public void deleteDraftByName(String var1, String var2) throws WikiException;

    public void renamePage(String var1, String var2, String var3, String var4, String var5) throws WikiException;

    public void movePage(WikiPageParams var1, WikiPageParams var2) throws WikiException;

    public List<PermissionEntry> getWikiPermission(String var1, String var2) throws WikiException;

    public void updateWikiPermission(String var1, String var2, List<PermissionEntry> var3) throws WikiException;

    public List<Page> getRelatedPagesOfPage(Page var1) throws WikiException;

    public Page getRelatedPage(String var1, String var2, String var3) throws WikiException;

    public void addRelatedPage(Page var1, Page var2) throws WikiException;

    public void removeRelatedPage(Page var1, Page var2) throws WikiException;

    public Page getExsitedOrNewDraftPageById(String var1, String var2, String var3, String var4) throws WikiException;

    public List<DraftPage> getDraftsOfPage(Long var1, String var2) throws WikiException;

    public DraftPage getDraft(WikiPageParams var1, String var2) throws WikiException;

    public DraftPage getLastestDraft(String var1) throws WikiException;

    public DraftPage getLatestDraftOfPage(Page var1, String var2) throws WikiException;

    public DraftPage getDraft(String var1, String var2) throws WikiException;

    public List<DraftPage> getDraftPagesOfUser(String var1) throws WikiException;

    public DraftPage createDraftPageForUser(DraftPage var1, String var2) throws WikiException;

    public DraftPage updateDraftPageForUser(DraftPage var1, String var2) throws WikiException;

    public PageList<SearchResult> search(WikiSearchData var1) throws WikiException;

    public List<TemplateSearchResult> searchTemplate(TemplateSearchData var1) throws WikiException;

    default public List<Attachment> getAttachmentsOfPage(Page page, boolean loadContent) throws WikiException {
        return this.getAttachmentsOfPage(page);
    }

    public List<Attachment> getAttachmentsOfPage(Page var1) throws WikiException;

    public void addAttachmentToPage(Attachment var1, Page var2) throws WikiException;

    public void deleteAttachmentOfPage(String var1, Page var2) throws WikiException;

    public Page getHelpSyntaxPage(String var1, boolean var2, List<ValuesParam> var3, ConfigurationManager var4) throws WikiException;

    public boolean hasPermissionOnPage(Page var1, PermissionType var2, Identity var3) throws WikiException;

    public boolean hasPermissionOnWiki(Wiki var1, PermissionType var2, Identity var3) throws WikiException;

    public boolean hasAdminSpacePermission(String var1, String var2, Identity var3) throws WikiException;

    public boolean hasAdminPagePermission(String var1, String var2, Identity var3) throws WikiException;

    public List<PageVersion> getVersionsOfPage(Page var1) throws WikiException;

    public List<PageHistory> getHistoryOfPage(Page var1) throws WikiException;

    public void addPageVersion(Page var1, String var2) throws WikiException;

    public void restoreVersionOfPage(String var1, Page var2) throws WikiException;

    public Page updatePage(Page var1) throws WikiException;

    public List<String> getPreviousNamesOfPage(Page var1) throws WikiException;

    public List<String> getWatchersOfPage(Page var1) throws WikiException;

    public void addWatcherToPage(String var1, Page var2) throws WikiException;

    public void deleteWatcherOfPage(String var1, Page var2) throws WikiException;

    public List<Page> getPagesOfWiki(String var1, String var2);

    public List<PageHistory> getPageHistoryVersionsByPageIdAndLang(Long var1, String var2);

    public DraftPage getLatestDraftPageByUserAndTargetPageAndLang(Long var1, String var2, String var3);

    public PageVersion getPublishedVersionByPageIdAndLang(Long var1, String var2);

    public List<String> getPageAvailableTranslationLanguages(Long var1);

    public void deleteVersionsByNoteIdAndLang(Long var1, String var2) throws WikiException;
}

