/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRepeater;
import org.exoplatform.webui.core.UIVirtualList;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/portal/webui/navigation/UIAddGroupNavigation.gtmpl", events={@EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}), @EventConfig(listeners={AddNavigationActionListener.class})}), @ComponentConfig(id="UIAddGroupNavigationGrid", type=UIRepeater.class, template="system:/groovy/portal/webui/navigation/UIGroupGrid.gtmpl")})
public class UIAddGroupNavigation
extends UIContainer {
    public UIAddGroupNavigation() throws Exception {
        UIVirtualList virtualList = (UIVirtualList)this.addChild(UIVirtualList.class, null, "AddGroupNavList");
        UIRepeater repeater = (UIRepeater)this.createUIComponent(UIRepeater.class, "UIAddGroupNavigationGrid", null);
        virtualList.setUIComponent((UIComponent)repeater);
        this.addChild(UIPopupWindow.class, null, "EditGroup");
    }

    public void loadGroups() throws Exception {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        UserPortalConfigService dataService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        final ArrayList<String> listGroup = new ArrayList<String>();
        if (userACL.isUserInGroup(userACL.getAdminGroups()) && !userACL.getSuperUser().equals(pContext.getRemoteUser())) {
            Collection temp = orgService.getGroupHandler().findGroupsOfUser(pContext.getRemoteUser());
            if (temp != null) {
                for (Iterator group : temp) {
                    Group m = (Group)group;
                    String groupId = m.getId().trim();
                    listGroup.add(groupId);
                }
            }
        } else {
            listGroup.addAll(dataService.getMakableNavigations(pContext.getRemoteUser(), false));
        }
        NavigationService navigationService = (NavigationService)this.getApplicationComponent(NavigationService.class);
        ArrayList<String> groupsHavingNavigation = new ArrayList<String>();
        for (String groupName : listGroup) {
            NavigationContext navigation = navigationService.loadNavigation(SiteKey.group((String)groupName));
            if (navigation == null || navigation.getState() == null) continue;
            groupsHavingNavigation.add(groupName);
        }
        listGroup.removeAll(groupsHavingNavigation);
        UIVirtualList virtualList = (UIVirtualList)this.getChild(UIVirtualList.class);
        int pageSize = 6;
        Iterator source = new Iterator<List<?>>(){
            int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < listGroup.size();
            }

            @Override
            public List<String> next() {
                if (this.hasNext()) {
                    ArrayList<String> list = new ArrayList<String>(6);
                    for (int i = this.currentIndex; i < this.currentIndex + 6 && i < listGroup.size(); ++i) {
                        list.add((String)listGroup.get(i));
                    }
                    this.currentIndex += 6;
                    return list;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        virtualList.dataBind(source);
    }

    public static class AddNavigationActionListener
    extends EventListener<UIAddGroupNavigation> {
        public void execute(Event<UIAddGroupNavigation> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIAddGroupNavigation uicomp = (UIAddGroupNavigation)((Object)event.getSource());
            String ownerId = event.getRequestContext().getRequestParameter("objectId");
            ownerId = URLDecoder.decode(ownerId);
            UIPortalApplication uiPortalApp = (UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class);
            NavigationService navigationService = (NavigationService)uicomp.getApplicationComponent(NavigationService.class);
            NavigationContext navigation = navigationService.loadNavigation(SiteKey.group((String)ownerId));
            if (navigation != null && navigation.getState() != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageNavigationForm.msg.existPageNavigation", (Object[])new String[]{ownerId}));
            } else {
                SiteKey key;
                NavigationContext existing;
                LayoutService layoutService = (LayoutService)uicomp.getApplicationComponent(LayoutService.class);
                if (layoutService.getPortalConfig("group", ownerId) == null) {
                    UserPortalConfigService configService = (UserPortalConfigService)uicomp.getApplicationComponent(UserPortalConfigService.class);
                    configService.createGroupSite(ownerId);
                }
                if ((existing = navigationService.loadNavigation(key = SiteKey.group((String)ownerId))) == null) {
                    navigationService.saveNavigation(new NavigationContext(key, new NavigationState(Integer.valueOf(0))));
                }
            }
            ctx.addUIComponentToUpdateByAjax((UIComponent)uicomp);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChild(UIWorkingWorkspace.class);
            uiWorkingWS.updatePortletsByName("GroupNavigationPortlet");
            uiWorkingWS.updatePortletsByName("UserToolbarGroupPortlet");
        }
    }
}

