/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.compression;

import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.CompressionCodecResolver;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.CompressionException;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.impl.lang.Services;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultCompressionCodecResolver
implements CompressionCodecResolver {
    private static final String MISSING_COMPRESSION_MESSAGE = "Unable to find an implementation for compression algorithm [%s] using java.util.ServiceLoader. Ensure you include a backing implementation .jar in the classpath, for example jjwt-impl.jar, or your own .jar for custom implementations.";
    private final Map<String, CompressionCodec> codecs;

    public DefaultCompressionCodecResolver() {
        HashMap<String, CompressionCodec> codecMap = new HashMap<String, CompressionCodec>();
        for (CompressionCodec codec : Services.loadAll(CompressionCodec.class)) {
            codecMap.put(codec.getAlgorithmName().toUpperCase(), codec);
        }
        codecMap.put(CompressionCodecs.DEFLATE.getAlgorithmName().toUpperCase(), CompressionCodecs.DEFLATE);
        codecMap.put(CompressionCodecs.GZIP.getAlgorithmName().toUpperCase(), CompressionCodecs.GZIP);
        this.codecs = Collections.unmodifiableMap(codecMap);
    }

    public CompressionCodec resolveCompressionCodec(Header header) {
        String cmpAlg = this.getAlgorithmFromHeader(header);
        boolean hasCompressionAlgorithm = Strings.hasText((String)cmpAlg);
        if (!hasCompressionAlgorithm) {
            return null;
        }
        return this.byName(cmpAlg);
    }

    private String getAlgorithmFromHeader(Header header) {
        Assert.notNull((Object)header, (String)"header cannot be null.");
        return header.getCompressionAlgorithm();
    }

    private CompressionCodec byName(String name) {
        Assert.hasText((String)name, (String)"'name' must not be empty");
        CompressionCodec codec = this.codecs.get(name.toUpperCase());
        if (codec == null) {
            throw new CompressionException(String.format(MISSING_COMPRESSION_MESSAGE, name));
        }
        return codec;
    }
}

