/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl.diff;

import java.util.List;
import org.exoplatform.services.document.diff.Chunk;
import org.exoplatform.services.document.diff.Delta;
import org.exoplatform.services.document.diff.DiffService;
import org.exoplatform.services.document.impl.diff.AddDeltaImpl;
import org.exoplatform.services.document.impl.diff.ChangeDeltaImpl;
import org.exoplatform.services.document.impl.diff.DeleteDeltaImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class DeltaImpl
implements Delta {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.DeltaImpl");
    protected Chunk original;
    protected Chunk revised;
    static Class[][] DeltaClass = new Class[2][2];

    public static DeltaImpl newDelta(Chunk orig, Chunk rev) {
        DeltaImpl result;
        Class c = DeltaClass[orig.size() > 0 ? 1 : 0][rev.size() > 0 ? 1 : 0];
        try {
            result = (DeltaImpl)c.newInstance();
        }
        catch (InstantiationException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return null;
        }
        catch (IllegalAccessException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return null;
        }
        result.init(orig, rev);
        return result;
    }

    protected DeltaImpl() {
    }

    protected DeltaImpl(Chunk orig, Chunk rev) {
        this.init(orig, rev);
    }

    protected void init(Chunk orig, Chunk rev) {
        this.original = orig;
        this.revised = rev;
    }

    @Override
    public abstract void verify(List var1) throws Exception;

    @Override
    public final void patch(List target) throws Exception {
        this.verify(target);
        this.applyTo(target);
    }

    @Override
    public abstract void applyTo(List var1);

    @Override
    public void toString(StringBuffer s) {
        this.original.rangeString(s);
        s.append("x");
        this.revised.rangeString(s);
        s.append(DiffService.NL);
        this.original.toString(s, "> ", "\n");
        s.append("---");
        s.append(DiffService.NL);
        this.revised.toString(s, "< ", "\n");
    }

    @Override
    public abstract void toRCSString(StringBuffer var1, String var2);

    @Override
    public String toRCSString(String EOL) {
        StringBuffer s = new StringBuffer();
        this.toRCSString(s, EOL);
        return s.toString();
    }

    @Override
    public Chunk getOriginal() {
        return this.original;
    }

    @Override
    public Chunk getRevised() {
        return this.revised;
    }

    static {
        DeltaImpl.DeltaClass[0][0] = ChangeDeltaImpl.class;
        DeltaImpl.DeltaClass[0][1] = AddDeltaImpl.class;
        DeltaImpl.DeltaClass[1][0] = DeleteDeltaImpl.class;
        DeltaImpl.DeltaClass[1][1] = ChangeDeltaImpl.class;
    }
}

