/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.kudos.model.GlobalSettings;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/kudos/api/settings")
@Tag(name="/kudos/api/settings", description="Manages Kudos global settings")
@RolesAllowed(value={"users"})
public class KudosSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(KudosSettingsREST.class);
    private KudosService kudosService;

    public KudosSettingsREST(KudosService kudosService) {
        this.kudosService = kudosService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get Kudos global settings", method="GET", description="Get Kudos global settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSettings() {
        return Response.ok((Object)this.kudosService.getGlobalSettings().toString()).build();
    }

    @Path(value="save")
    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Saves Kudos global settings", method="POST", description="Saves Kudos global settings and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveSettings(GlobalSettings settings) {
        if (settings == null) {
            LOG.warn((Object)"Bad request sent to server with empty 'settings' parameter");
            return Response.status((int)400).build();
        }
        try {
            this.kudosService.saveGlobalSettings(settings);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving kudos settings: {}", new Object[]{settings, e});
            return Response.serverError().build();
        }
    }
}

