/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.entity;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.hibernate.annotations.Type;
import org.json.simple.JSONObject;

@Entity(name="GateInWindow")
@ExoEntity
@Table(name="PORTAL_WINDOWS")
@NamedQueries(value={@NamedQuery(name="WindowEntity.findByIds", query="SELECT w FROM GateInWindow w WHERE w.id IN (:ids)"), @NamedQuery(name="WindowEntity.findByContentIds", query="SELECT w.id FROM GateInWindow w WHERE w.contentId IN (:contentIds)"), @NamedQuery(name="WindowEntity.updateContentId", query="UPDATE GateInWindow SET contentId = :newContentId WHERE contentId = :oldContentId"), @NamedQuery(name="WindowEntity.deleteByContentId", query="DELETE GateInWindow WHERE contentId = :contentId")})
public class WindowEntity
extends ComponentEntity
implements Serializable {
    private static final long serialVersionUID = 6633792468705838255L;
    @Id
    @SequenceGenerator(name="SEQ_WINDOW_ID_GENERATOR", sequenceName="SEQ_WINDOW_ID_GENERATOR", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WINDOW_ID_GENERATOR")
    @Column(name="ID")
    protected Long id;
    @Column(name="TITLE", length=200)
    private String title;
    @Column(name="ICON", length=200)
    private String icon;
    @Column(name="DESCRIPTION", length=2000)
    private String description;
    @Column(name="SHOW_INFO_BAR")
    private boolean showInfoBar;
    @Column(name="SHOW_APP_STATE")
    private boolean showApplicationState;
    @Column(name="SHOW_APP_MODE")
    private boolean showApplicationMode;
    @Column(name="THEME", length=200)
    private String theme;
    @Column(name="WIDTH", length=20)
    private String width;
    @Column(name="HEIGHT", length=20)
    private String height;
    @Column(name="PROPERTIES", length=2000)
    private String properties = WindowEntity.getJSONString(new JSONObject());
    @Column(name="APP_TYPE")
    private AppType appType;
    @Column(name="CONTENT_ID", length=200)
    private String contentId;
    @Lob
    @Type(type="org.hibernate.type.MaterializedBlobType")
    @Column(name="CUSTOMIZATION", length=10000)
    @Basic(fetch=FetchType.LAZY)
    private byte[] customization;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isShowInfoBar() {
        return this.showInfoBar;
    }

    public void setShowInfoBar(boolean showInfoBar) {
        this.showInfoBar = showInfoBar;
    }

    public boolean isShowApplicationState() {
        return this.showApplicationState;
    }

    public void setShowApplicationState(boolean showApplicationState) {
        this.showApplicationState = showApplicationState;
    }

    public boolean isShowApplicationMode() {
        return this.showApplicationMode;
    }

    public void setShowApplicationMode(boolean showApplicationMode) {
        this.showApplicationMode = showApplicationMode;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public AppType getAppType() {
        return this.appType;
    }

    public void setAppType(AppType appType) {
        this.appType = appType;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public byte[] getCustomization() {
        return this.customization;
    }

    public void setCustomization(byte[] customization) {
        this.customization = customization;
    }

    @Override
    public ComponentEntity.TYPE getType() {
        return ComponentEntity.TYPE.WINDOW;
    }

    public static enum AppType {
        PORTLET;

    }
}

