/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.translation.storage.cache;

import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.storage.TranslationStorage;
import io.meeds.social.translation.storage.cache.model.CacheKey;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.metadata.MetadataService;

public class CachedTranslationStorage
extends TranslationStorage {
    private static final Log LOG = ExoLogger.getLogger(CachedTranslationStorage.class);
    private static final String TRANSLATION_CACHE_NAME = "social.translation";
    private ExoCache<CacheKey, TranslationField> translationCache;
    private FutureExoCache<CacheKey, TranslationField, Object> translationFutureCache;

    public CachedTranslationStorage(MetadataService metadataService, CacheService cacheService) {
        super(metadataService);
        this.translationCache = cacheService.getCacheInstance(TRANSLATION_CACHE_NAME);
        Loader<CacheKey, TranslationField, Object> labelsLoader = new Loader<CacheKey, TranslationField, Object>(){

            public TranslationField retrieve(Object context, CacheKey key) throws Exception {
                return CachedTranslationStorage.super.getTranslationField(key.getObjectType(), key.getObjectId(), key.getFieldName());
            }
        };
        this.translationFutureCache = new FutureExoCache((Loader)labelsLoader, this.translationCache);
    }

    @Override
    public TranslationField getTranslationField(String objectType, long objectId, String fieldName) {
        TranslationField translationField = (TranslationField)this.translationFutureCache.get(null, (Object)new CacheKey(objectType, objectId, fieldName));
        return translationField.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTranslationLabel(String objectType, long objectId, String fieldName, Locale locale) {
        try {
            super.deleteTranslationLabel(objectType, objectId, fieldName, locale);
        }
        finally {
            this.clearCache(objectType, objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTranslationLabels(String objectType, long objectId) {
        try {
            super.deleteTranslationLabels(objectType, objectId);
        }
        finally {
            this.clearCache(objectType, objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTranslationLabel(String objectType, long objectId, String fieldName, Locale locale, String label, long audienceId, long spaceId) {
        try {
            super.saveTranslationLabel(objectType, objectId, fieldName, locale, label, audienceId, spaceId);
        }
        finally {
            this.clearCache(objectType, objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTranslationLabels(String objectType, long objectId, String fieldName, Map<Locale, String> labels, long audienceId, long spaceId) {
        try {
            super.saveTranslationLabels(objectType, objectId, fieldName, labels, audienceId, spaceId);
        }
        finally {
            this.clearCache(objectType, objectId);
        }
    }

    private void clearCache(final String objectType, final long objectId) {
        try {
            this.translationCache.select((CachedObjectSelector)new CachedObjectSelector<CacheKey, TranslationField>(){

                public boolean select(CacheKey key, ObjectCacheInfo<? extends TranslationField> ocinfo) {
                    return StringUtils.equals((CharSequence)key.getObjectType(), (CharSequence)objectType) && objectId == key.getObjectId();
                }

                public void onSelect(ExoCache<? extends CacheKey, ? extends TranslationField> cache, CacheKey key, ObjectCacheInfo<? extends TranslationField> ocinfo) throws Exception {
                    cache.remove((Serializable)key);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Unable to clean cache entries for object {} with id {}. Clean all cache entries to preserve coherence.", new Object[]{objectType, objectId, e});
            this.translationCache.clearCache();
        }
    }
}

