/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.ProjectDto;

public class StatusDto
implements Serializable {
    private Long id;
    private String name;
    private Integer rank;
    private List<Task> tasks;
    private ProjectDto project;

    public StatusDto(StatusDto status) {
        this.id = status.getId();
        this.name = status.getName();
        this.rank = status.getRank();
        this.project = status.getProject();
    }

    public StatusDto(long id, String name) {
        this.id = id;
        this.name = name;
    }

    public StatusDto(long id, String name, Integer rank, ProjectDto project) {
        this.id = id;
        this.name = name;
        this.rank = rank;
        this.project = project;
    }

    public StatusDto clone() {
        StatusDto status = new StatusDto(this.getId(), this.getName(), this.getRank(), this.getProject().clone(false));
        return status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusDto status = (StatusDto)o;
        if (this.id != status.getId()) {
            return false;
        }
        if (this.name != null ? !this.name.equals(status.getName()) : status.getName() != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals(status.getProject()) : status.getProject() != null) {
            return false;
        }
        return !(this.rank != null ? !this.rank.equals(status.getRank()) : status.getRank() != null);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.rank, this.project);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getRank() {
        return this.rank;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public ProjectDto getProject() {
        return this.project;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public void setProject(ProjectDto project) {
        this.project = project;
    }

    public String toString() {
        return "StatusDto(id=" + this.getId() + ", name=" + this.getName() + ", rank=" + this.getRank() + ", tasks=" + this.getTasks() + ", project=" + this.getProject() + ")";
    }

    public StatusDto() {
    }
}

