/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.ModelData;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class Container
extends ModelObject
implements Cloneable,
IUnmarshallable,
IMarshallable {
    public static final String EVERYONE = "Everyone";
    public static final List<String> DEFAULT_ACCESS_PERMISSIONS = Collections.singletonList("Everyone");
    public static final List<String> DEFAULT_MOVE_APPLICATIONS_PERMISSIONS = Collections.singletonList("Everyone");
    public static final List<String> DEFAULT_MOVE_CONTAINERS_PERMISSIONS = Collections.singletonList("Everyone");
    protected String id;
    protected String name;
    protected String icon;
    protected String template;
    protected String factoryId;
    protected String title;
    protected String description;
    protected String width;
    protected String height;
    protected String cssClass;
    protected String profiles;
    protected String decorator;
    protected String[] accessPermissions;
    protected String[] moveAppsPermissions;
    protected String[] moveContainersPermissions;
    protected ArrayList<ModelObject> children;
    public static final String JiBX_bindingList = "|org.exoplatform.portal.application.JiBX_bindingFactory|";

    public Container() {
        this.setDefaultPermissions();
        this.children = new ArrayList();
    }

    public Container(String storageId) {
        super(storageId);
        this.setDefaultPermissions();
        this.children = new ArrayList();
    }

    public Container(ContainerData data) {
        super(data.getStorageId());
        ArrayList<ModelObject> children = new ArrayList<ModelObject>();
        for (ComponentData child : data.getChildren()) {
            ModelObject m = ModelObject.build(child);
            if (m == null) continue;
            children.add(ModelObject.build(child));
        }
        this.id = data.getId();
        this.name = data.getName();
        this.icon = data.getIcon();
        this.template = data.getTemplate();
        this.factoryId = data.getFactoryId();
        this.title = data.getTitle();
        this.description = data.getDescription();
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.cssClass = data.getCssClass();
        this.profiles = data.getProfiles();
        this.accessPermissions = data.getAccessPermissions().toArray(new String[data.getAccessPermissions().size()]);
        List<String> permisssions = data.getMoveAppsPermissions();
        this.moveAppsPermissions = permisssions != null ? permisssions.toArray(new String[permisssions.size()]) : null;
        permisssions = data.getMoveContainersPermissions();
        this.moveContainersPermissions = permisssions != null ? permisssions.toArray(new String[permisssions.size()]) : null;
        this.children = children;
    }

    private void setDefaultPermissions() {
        List<String> permissions = DEFAULT_MOVE_APPLICATIONS_PERMISSIONS;
        this.moveAppsPermissions = permissions.toArray(new String[permissions.size()]);
        permissions = DEFAULT_MOVE_CONTAINERS_PERMISSIONS;
        this.moveContainersPermissions = permissions.toArray(new String[permissions.size()]);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public ArrayList<ModelObject> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<ModelObject> children) {
        this.children = children;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public void setFactoryId(String factoryId) {
        this.factoryId = factoryId;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(String[] accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    public String[] getMoveAppsPermissions() {
        return this.moveAppsPermissions;
    }

    public void setMoveAppsPermissions(String[] moveAppsPermissions) {
        this.moveAppsPermissions = moveAppsPermissions;
    }

    public String[] getMoveContainersPermissions() {
        return this.moveContainersPermissions;
    }

    public void setMoveContainersPermissions(String[] moveContainersPermissions) {
        this.moveContainersPermissions = moveContainersPermissions;
    }

    public String getDecorator() {
        return null;
    }

    public void setDecorator(String decorator) {
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    @Override
    public ContainerData build() {
        List<ComponentData> children = this.buildChildren();
        return new ContainerData(this.storageId, this.id, this.name, this.icon, this.template, this.factoryId, this.title, this.description, this.width, this.height, this.cssClass, this.profiles, Utils.safeImmutableList(this.accessPermissions), Utils.safeImmutableList(this.moveAppsPermissions), Utils.safeImmutableList(this.moveContainersPermissions), children);
    }

    @Override
    public void resetStorage() {
        super.resetStorage();
        if (this.children != null && !this.children.isEmpty()) {
            for (ModelObject child : this.children) {
                child.resetStorage();
            }
        }
    }

    public Container clone() {
        try {
            return (Container)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new Container(this.build());
        }
    }

    protected List<ComponentData> buildChildren() {
        if (StringUtils.isNotBlank((CharSequence)this.profiles)) {
            Set activeProfiles = Tools.parseCommaList((String)this.profiles);
            if (ExoContainer.getProfiles().stream().noneMatch(activeProfiles::contains)) {
                return Collections.emptyList();
            }
        }
        if (this.children != null && !this.children.isEmpty()) {
            ArrayList<ComponentData> dataChildren = new ArrayList<ComponentData>();
            for (int i = 0; i < this.children.size(); ++i) {
                Container container;
                String nodeProfiles;
                ModelObject node = this.children.get(i);
                if (node instanceof Container && StringUtils.isNotBlank((CharSequence)(nodeProfiles = (container = (Container)node).getProfiles()))) {
                    Set activeProfiles = Tools.parseCommaList((String)nodeProfiles);
                    if (ExoContainer.getProfiles().stream().noneMatch(activeProfiles::contains)) continue;
                }
                ModelData data = node.build();
                ComponentData componentData = (ComponentData)data;
                dataChildren.add(componentData);
            }
            return Collections.unmodifiableList(dataChildren);
        }
        return Collections.emptyList();
    }

    public /* synthetic */ void JiBX_access_store_id_2_0(String arg1) {
        this.id = arg1;
    }

    public /* synthetic */ void JiBX_access_store_template_2_0(String arg1) {
        this.template = arg1;
    }

    public /* synthetic */ void JiBX_access_store_decorator_2_0(String arg1) {
        this.decorator = arg1;
    }

    public /* synthetic */ void JiBX_access_store_width_2_0(String arg1) {
        this.width = arg1;
    }

    public /* synthetic */ void JiBX_access_store_height_2_0(String arg1) {
        this.height = arg1;
    }

    public /* synthetic */ void JiBX_access_store_cssClass_2_0(String arg1) {
        this.cssClass = arg1;
    }

    public /* synthetic */ void JiBX_access_store_profiles_2_0(String arg1) {
        this.profiles = arg1;
    }

    public /* synthetic */ void JiBX_access_store_name_2_0(String arg1) {
        this.name = arg1;
    }

    public /* synthetic */ void JiBX_access_store_title_2_0(String arg1) {
        this.title = arg1;
    }

    public /* synthetic */ void JiBX_access_store_icon_2_0(String arg1) {
        this.icon = arg1;
    }

    public /* synthetic */ void JiBX_access_store_accessPermissions_2_0(String[] arg1) {
        this.accessPermissions = arg1;
    }

    public /* synthetic */ void JiBX_access_store_factoryId_2_0(String arg1) {
        this.factoryId = arg1;
    }

    public /* synthetic */ void JiBX_access_store_description_2_0(String arg1) {
        this.description = arg1;
    }

    public /* synthetic */ void JiBX_access_store_moveAppsPermissions_2_0(String[] arg1) {
        this.moveAppsPermissions = arg1;
    }

    public /* synthetic */ void JiBX_access_store_moveContainersPermissions_2_0(String[] arg1) {
        this.moveContainersPermissions = arg1;
    }

    public /* synthetic */ ArrayList JiBX_access_load_children_2_0() {
        return this.children;
    }

    public /* synthetic */ void JiBX_access_store_children_2_0(ArrayList arg1) {
        this.children = arg1;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.Container").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.portal.config.model.Container";
    }

    public /* synthetic */ String JiBX_access_load_id_2_0() {
        return this.id;
    }

    public /* synthetic */ String JiBX_access_load_template_2_0() {
        return this.template;
    }

    public /* synthetic */ String JiBX_access_load_decorator_2_0() {
        return this.decorator;
    }

    public /* synthetic */ String JiBX_access_load_width_2_0() {
        return this.width;
    }

    public /* synthetic */ String JiBX_access_load_height_2_0() {
        return this.height;
    }

    public /* synthetic */ String JiBX_access_load_cssClass_2_0() {
        return this.cssClass;
    }

    public /* synthetic */ String JiBX_access_load_profiles_2_0() {
        return this.profiles;
    }

    public /* synthetic */ String JiBX_access_load_name_2_0() {
        return this.name;
    }

    public /* synthetic */ String JiBX_access_load_title_2_0() {
        return this.title;
    }

    public /* synthetic */ String JiBX_access_load_icon_2_0() {
        return this.icon;
    }

    public /* synthetic */ String[] JiBX_access_load_accessPermissions_2_0() {
        return this.accessPermissions;
    }

    public /* synthetic */ String JiBX_access_load_factoryId_2_0() {
        return this.factoryId;
    }

    public /* synthetic */ String JiBX_access_load_description_2_0() {
        return this.description;
    }

    public /* synthetic */ String[] JiBX_access_load_moveAppsPermissions_2_0() {
        return this.moveAppsPermissions;
    }

    public /* synthetic */ String[] JiBX_access_load_moveContainersPermissions_2_0() {
        return this.moveContainersPermissions;
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.portal.config.model.Container").marshal((Object)this, arg1);
    }
}

