/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveEnvironment;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;

public class PortalEnvironment
extends CloudDriveEnvironment {
    protected final Map<CloudDrive.Command, Settings> config = Collections.synchronizedMap(new WeakHashMap());

    public void configure(CloudDrive.Command command) throws CloudDriveException {
        super.configure(command);
        this.config.put(command, new Settings(WebuiRequestContext.getCurrentInstance()));
    }

    public void prepare(CloudDrive.Command command) throws CloudDriveException {
        super.prepare(command);
        Settings settings = this.config.get(command);
        if (settings == null) {
            throw new CloudDriveException(((Object)((Object)this)).getClass().getName() + " setting not configured for " + String.valueOf(command) + " to be prepared.");
        }
        settings.prevContext = WebuiRequestContext.getCurrentInstance();
        WebuiRequestContext.setCurrentInstance((RequestContext)settings.context);
    }

    public void cleanup(CloudDrive.Command command) throws CloudDriveException {
        Settings settings = this.config.remove(command);
        if (settings == null) {
            throw new CloudDriveException(((Object)((Object)this)).getClass().getName() + " setting not configured for " + String.valueOf(command) + " to be cleaned.");
        }
        WebuiRequestContext.setCurrentInstance((RequestContext)settings.prevContext);
        super.cleanup(command);
    }

    protected class Settings {
        final RequestContext context;
        RequestContext prevContext;

        Settings(RequestContext context) {
            this.context = context;
        }
    }
}

