/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

public class LocalizationLifecycle
extends BaseComponentPlugin
implements ApplicationLifecycle<WebuiRequestContext> {
    public static final String SAVE_PROFILE_LOCALE_ATTR = "SaveProfileLocale";
    private static final Log LOG = ExoLogger.getLogger((String)"portal:LocalizationLifecycle");
    private static final String LOCALE_COOKIE = "LOCALE";
    private static final String LOCALE_SESSION_ATTR = "org.gatein.LOCALE";
    private static final String PREV_LOCALE_SESSION_ATTR = "org.gatein.LAST_LOCALE";
    private ExoContainer container;
    private LocalePolicy localePolicy;
    private LocaleConfigService localeConfigService;
    private OrganizationService organizationService;

    public void onInit(Application app) throws Exception {
        this.container = app.getApplicationServiceContainer();
        this.localePolicy = (LocalePolicy)this.container.getComponentInstanceOfType(LocalePolicy.class);
        this.localeConfigService = (LocaleConfigService)this.container.getComponentInstanceOfType(LocaleConfigService.class);
        this.organizationService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        if (!(context instanceof PortalRequestContext)) {
            return;
        }
        PortalRequestContext reqCtx = (PortalRequestContext)context;
        Locale requestLocale = reqCtx.getRequestLocale();
        HttpServletRequest request = reqCtx.getRequest();
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((HttpServletRequest)request);
        localeCtx.setRequestLocale(requestLocale);
        Locale locale = this.localePolicy.determineLocale(localeCtx);
        reqCtx.setLocale(locale);
        if (!(request.getRemoteUser() == null || localeCtx.getUserProfileLocale() != null && Objects.equals(locale, localeCtx.getUserProfileLocale()))) {
            reqCtx.setAttribute(SAVE_PROFILE_LOCALE_ATTR, true);
        }
        this.resetOrientation(reqCtx, locale);
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext reqCtx = (PortalRequestContext)context;
        Locale loc = reqCtx.getLocale();
        Locale sessLocale = this.getPreviousLocale(reqCtx.getRequest());
        if (reqCtx.getAttribute(SAVE_PROFILE_LOCALE_ATTR) != null || loc != null && sessLocale != null && !loc.equals(sessLocale)) {
            this.saveLocale(reqCtx, loc);
            this.resetOrientation(reqCtx, loc);
            this.savePreviousLocale(reqCtx, loc);
        } else if (sessLocale == null) {
            this.savePreviousLocale(reqCtx, loc);
        }
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onDestroy(Application app) throws Exception {
    }

    private UserProfile loadUserProfile(PortalRequestContext context) {
        UserProfile userProfile = null;
        String userName = context.getRemoteUser();
        if (userName != null) {
            try {
                userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(userName);
                if (userProfile == null) {
                    userProfile = this.organizationService.getUserProfileHandler().createUserProfileInstance(userName);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to load UserProfile for user {}", new Object[]{userName, e});
            }
        }
        return userProfile;
    }

    private Locale getPreviousLocale(HttpServletRequest request) {
        return this.getLocaleFromSession(request, PREV_LOCALE_SESSION_ATTR);
    }

    private Locale getLocaleFromSession(HttpServletRequest request, String attrName) {
        String lang = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            lang = (String)session.getAttribute(attrName);
        }
        return lang != null ? LocaleContextInfo.getLocale(lang) : null;
    }

    private void saveLocale(PortalRequestContext context, Locale loc) {
        String user = context.getRemoteUser();
        if (StringUtils.isBlank((CharSequence)user)) {
            this.saveLocaleToCookie(context, loc);
        } else {
            this.saveLocaleToUserProfile(context, loc, user);
        }
        this.saveSessionLocale(context, loc);
    }

    private void resetOrientation(PortalRequestContext context, Locale loc) {
        LocaleConfig localeConfig = this.localeConfigService.getLocaleConfig(LocaleContextInfo.getLocaleAsString((Locale)loc));
        if (localeConfig == null) {
            LOG.warn((Object)("Locale changed to unsupported Locale during request processing: " + String.valueOf(loc)));
            return;
        }
        ((UIPortalApplication)context.getUIApplication()).setOrientation(localeConfig.getOrientation());
    }

    private void saveSessionLocale(PortalRequestContext context, Locale loc) {
        this.saveLocaleToSession(context, LOCALE_SESSION_ATTR, loc);
    }

    private void savePreviousLocale(PortalRequestContext context, Locale loc) {
        this.saveLocaleToSession(context, PREV_LOCALE_SESSION_ATTR, loc);
    }

    private void saveLocaleToSession(PortalRequestContext context, String attrName, Locale loc) {
        HttpServletRequest res = context.getRequest();
        HttpSession session = res.getSession(false);
        if (session != null) {
            session.setAttribute(attrName, (Object)LocaleContextInfo.getLocaleAsString((Locale)loc));
        }
    }

    private void saveLocaleToCookie(PortalRequestContext context, Locale loc) {
        HttpServletResponse res = context.getResponse();
        Cookie cookie = new Cookie(LOCALE_COOKIE, LocaleContextInfo.getLocaleAsString((Locale)loc));
        cookie.setMaxAge(Integer.MAX_VALUE);
        cookie.setPath("/");
        res.addCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLocaleToUserProfile(PortalRequestContext context, Locale loc, String user) {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            UserProfile userProfile = this.loadUserProfile(context);
            if (userProfile == null) {
                LOG.warn("Unable to save locale into profile for user {}", new Object[]{user});
            } else {
                userProfile.getUserInfoMap().put("user.language", LocaleContextInfo.getLocaleAsString((Locale)loc));
                this.organizationService.getUserProfileHandler().saveUserProfile(userProfile, false);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to save profile for user {}", new Object[]{user, e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

