/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import juzu.impl.common.AbstractAnnotatedElement;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.Tools;
import juzu.impl.request.BeanParameter;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.PhaseParameter;
import juzu.request.Phase;

public final class ControllerHandler<P extends Phase> {
    private final String id;
    private final P phase;
    private final Class<?> type;
    private final Method method;
    private final List<ControlParameter> parameterList;
    private final Map<String, ControlParameter> parameterMap;
    final boolean requiresPrefix;
    private final MethodHandle handle;

    public ControllerHandler(String id, P phase, Class<?> type, Method method, List<ControlParameter> parameterList) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        parameterList = new ArrayList<ControlParameter>(parameterList);
        for (int i = 0; i < parameterList.size(); ++i) {
            ControlParameter parameter = parameterList.get(i);
            AbstractAnnotatedElement annotations = AbstractAnnotatedElement.wrap(parameterAnnotations[i]);
            if (parameter instanceof ContextualParameter) {
                Type genericParameterType = genericParameterTypes[i];
                parameterList.set(i, new ContextualParameter(parameter.getName(), annotations, parameterTypes[i], genericParameterType));
                continue;
            }
            if (parameter instanceof PhaseParameter) {
                PhaseParameter phaseParameter = (PhaseParameter)parameter;
                parameterList.set(i, new PhaseParameter(parameter.getName(), annotations, parameterTypes[i], phaseParameter.getValueType(), phaseParameter.getCardinality(), phaseParameter.getAlias()));
                continue;
            }
            parameterList.set(i, new BeanParameter(parameter.getName(), annotations, parameter.getType()));
        }
        LinkedHashMap<String, ControlParameter> argumentMap = new LinkedHashMap<String, ControlParameter>();
        for (ControlParameter argument : parameterList) {
            argumentMap.put(argument.getName(), argument);
        }
        boolean requiresPrefix = false;
        HashSet<String> set = new HashSet<String>();
        block2: for (ControlParameter parameter : parameterList) {
            if (parameter instanceof PhaseParameter) {
                if (set.add(parameter.getName())) continue;
                requiresPrefix = true;
                break;
            }
            if (!(parameter instanceof BeanParameter)) continue;
            BeanParameter beanParameter = (BeanParameter)parameter;
            for (Field field : beanParameter.getType().getFields()) {
                if (set.add(field.getName())) continue;
                requiresPrefix = true;
                break;
            }
            for (AccessibleObject accessibleObject : beanParameter.getType().getMethods()) {
                String name;
                String methodName = ((Method)accessibleObject).getName();
                if (methodName.length() <= 3 || !methodName.startsWith("get") || ((Method)accessibleObject).getParameterTypes().length != 0 || ((Method)accessibleObject).getReturnType() == Void.class || set.add(name = Introspector.decapitalize(methodName.substring("get".length())))) continue;
                requiresPrefix = true;
                continue block2;
            }
        }
        this.id = id;
        this.phase = phase;
        this.type = type;
        this.method = method;
        this.parameterList = Tools.safeUnmodifiableList(parameterList);
        this.parameterMap = Collections.unmodifiableMap(argumentMap);
        this.requiresPrefix = requiresPrefix;
        this.handle = new MethodHandle(method);
    }

    public MethodHandle getHandle() {
        return this.handle;
    }

    public String getId() {
        return this.id;
    }

    public P getPhase() {
        return this.phase;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.method.getName();
    }

    public ControlParameter getParameter(String name) {
        return this.parameterMap.get(name);
    }

    public List<ControlParameter> getParameters() {
        return this.parameterList;
    }

    public Set<String> getParameterNames() {
        return this.parameterMap.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[type=").append(this.type.getName()).append(",method=");
        sb.append(this.method.getName()).append("(");
        Class<?>[] types = this.method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.parameterList.get(i).getName()).append("=").append(types[i].getName());
        }
        sb.append(")]");
        return sb.toString();
    }
}

