/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcache;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.exoplatform.commons.cache.future.FutureCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcache.MarkupFragment;
import org.exoplatform.services.portletcache.PortletRenderContext;
import org.exoplatform.services.portletcache.PortletRenderer;
import org.exoplatform.services.portletcache.WindowKey;

@Deprecated
class PortletFutureCache
extends FutureCache<WindowKey, MarkupFragment, PortletRenderContext> {
    private static final int DEFAULT_CACHE_SIZE = 5000;
    private final ConcurrentHashMap<WindowKey, MarkupFragment> entries;
    private final Log log;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private int cleanupCache;
    private int cacheMaxSize = 5000;
    private ScheduledFuture<?> scheduled;

    PortletFutureCache(Log log, int cleanupCache) {
        super((Loader)new PortletRenderer(log));
        this.log = log;
        this.entries = new ConcurrentHashMap();
        this.cleanupCache = PortletFutureCache.preventWrongCleanupCacheValue(cleanupCache);
        this.scheduled = null;
    }

    PortletFutureCache(Log log, int cleanupCache, int cacheSize) {
        this(log, cleanupCache);
        this.cacheMaxSize = cacheSize;
    }

    private static int preventWrongCleanupCacheValue(int value) {
        return value < 0 ? 300 : value;
    }

    public int getCleanupCache() {
        return this.cleanupCache;
    }

    public void updateCleanupCache(int cleanupCache) {
        this.cleanupCache = cleanupCache;
        if (this.scheduled != null) {
            this.stop();
            this.start();
        }
    }

    protected int getCacheSize() {
        return this.entries.size();
    }

    protected int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    protected void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    protected void clearCache() {
        if (this.scheduled != null) {
            this.stop();
            this.entries.clear();
            this.start();
        } else {
            this.entries.clear();
        }
    }

    protected boolean containsKey(WindowKey key) {
        return this.entries.containsKey(key);
    }

    protected MarkupFragment get(WindowKey key) {
        MarkupFragment value = this.entries.get(key);
        if (value != null) {
            if (value.expirationTimeMillis > System.currentTimeMillis()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Using cached markup for portlet " + String.valueOf(key)));
                }
                return value;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Expired markup for portlet " + String.valueOf(key)));
            }
            this.entries.remove(key);
            return null;
        }
        return null;
    }

    protected void put(WindowKey key, MarkupFragment value) {
        boolean canInsert = false;
        if (value.expirationTimeMillis > System.currentTimeMillis()) {
            if (this.entries.size() < this.cacheMaxSize) {
                canInsert = true;
            }
            if (canInsert) {
                this.entries.put(key, value);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Cached markup for portlet " + String.valueOf(key)));
                }
            }
        }
    }

    protected void putOnly(WindowKey key, MarkupFragment value) {
        this.put(key, value);
    }

    public void start() {
        if (this.scheduled == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Starting cache cleaner with a period of " + this.cleanupCache + " seconds"));
            }
            if (this.scheduler.isShutdown()) {
                this.scheduler = Executors.newScheduledThreadPool(1);
            }
            this.scheduled = this.scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    long now = System.currentTimeMillis();
                    Iterator<Map.Entry<WindowKey, MarkupFragment>> i = PortletFutureCache.this.entries.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry<WindowKey, MarkupFragment> entry = i.next();
                        if (entry.getValue().expirationTimeMillis >= now) continue;
                        if (PortletFutureCache.this.log.isTraceEnabled()) {
                            PortletFutureCache.this.log.trace((Object)("Removing expired entry " + entry.getKey().getWindowId()));
                        }
                        i.remove();
                    }
                }
            }, this.cleanupCache, this.cleanupCache, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.scheduled != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Stopping cache cleaner");
            }
            this.scheduled.cancel(false);
            this.scheduled = null;
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }
}

