/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.google;

import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleRefreshTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Tokeninfo;
import com.google.api.services.oauth2.model.Userinfo;
import com.google.api.services.plus.Plus;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.google.GoogleAccessTokenContext;
import io.meeds.oauth.google.GoogleProcessor;
import io.meeds.oauth.google.GoogleRequest;
import io.meeds.oauth.spi.InteractionState;
import io.meeds.oauth.spi.OAuthCodec;
import io.meeds.oauth.utils.OAuthPersistenceUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.security.security.SecureRandomService;

public class GoogleProcessorImpl
implements GoogleProcessor {
    private static Log log = ExoLogger.getLogger(GoogleProcessorImpl.class);
    private final String redirectURL;
    private final String clientID;
    private final String clientSecret;
    private final Set<String> scopes = new HashSet<String>();
    private final String accessType;
    private final String applicationName;
    private final int chunkLength;
    private final SecureRandomService secureRandomService;
    private final HttpTransport TRANSPORT = new NetHttpTransport();
    private final JacksonFactory JSON_FACTORY = new JacksonFactory();

    public GoogleProcessorImpl(ExoContainerContext context, InitParams params, SecureRandomService secureRandomService) {
        this.clientID = params.getValueParam("clientId").getValue();
        this.clientSecret = params.getValueParam("clientSecret").getValue();
        String redirectURLParam = params.getValueParam("redirectURL").getValue();
        String scope = params.getValueParam("scope").getValue();
        this.accessType = params.getValueParam("accessType").getValue();
        ValueParam appNameParam = params.getValueParam("applicationName");
        this.applicationName = appNameParam != null && appNameParam.getValue() != null ? appNameParam.getValue() : "GateIn portal";
        if (this.clientID == null || this.clientID.length() == 0 || this.clientID.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientId' needs to be provided. The value should be clientId of your Google application");
        }
        if (this.clientSecret == null || this.clientSecret.length() == 0 || this.clientSecret.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientSecret' needs to be provided. The value should be clientSecret of your Google application");
        }
        this.redirectURL = redirectURLParam == null || redirectURLParam.length() == 0 ? "http://localhost:8080/" + context.getName() + "/googleAuth" : redirectURLParam.replaceAll("@@portal.container.name@@", context.getName());
        this.addScopesFromString(scope, this.scopes);
        this.chunkLength = OAuthPersistenceUtils.getChunkLength(params);
        if (log.isDebugEnabled()) {
            log.debug((Object)("configuration: clientId=" + this.clientID + ", clientSecret=" + this.clientSecret + ", redirectURL=" + this.redirectURL + ", scope=" + String.valueOf(this.scopes) + ", accessType=" + this.accessType + ", applicationName=" + this.applicationName + ", chunkLength=" + this.chunkLength));
        }
        this.secureRandomService = secureRandomService;
    }

    @Override
    public InteractionState<GoogleAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, OAuthException {
        return this.processOAuthInteractionImpl(httpRequest, httpResponse, this.scopes);
    }

    @Override
    public InteractionState<GoogleAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String scope) throws IOException, OAuthException {
        HashSet<String> scopes = new HashSet<String>();
        this.addScopesFromString(scope, scopes);
        return this.processOAuthInteractionImpl(httpRequest, httpResponse, scopes);
    }

    protected InteractionState<GoogleAccessTokenContext> processOAuthInteractionImpl(HttpServletRequest request, HttpServletResponse response, Set<String> scopes) throws IOException {
        HttpSession session = request.getSession();
        String state = (String)session.getAttribute("_authState");
        if (state == null || state.isEmpty()) {
            return this.initialInteraction(request, response, scopes);
        }
        if (state.equals(InteractionState.State.AUTH.name())) {
            GoogleTokenResponse tokenResponse = this.obtainAccessToken(request);
            GoogleAccessTokenContext accessTokenContext = this.validateTokenAndUpdateScopes(new GoogleAccessTokenContext(tokenResponse, new String[0]));
            session.removeAttribute("_authState");
            session.removeAttribute("_verificationState");
            return new InteractionState<GoogleAccessTokenContext>(InteractionState.State.FINISH, accessTokenContext);
        }
        return new InteractionState<Object>(InteractionState.State.valueOf(state), null);
    }

    protected InteractionState<GoogleAccessTokenContext> initialInteraction(HttpServletRequest request, HttpServletResponse response, Set<String> scopes) throws IOException {
        String verificationState = String.valueOf(this.secureRandomService.getSecureRandom().nextLong());
        String authorizeUrl = new GoogleAuthorizationCodeRequestUrl(this.clientID, this.redirectURL, scopes).setState(verificationState).setAccessType(this.accessType).build();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting OAuth2 interaction with Google+");
            log.trace((Object)("URL to send to Google+: " + authorizeUrl));
        }
        HttpSession session = request.getSession();
        session.setAttribute("_verificationState", (Object)verificationState);
        session.setAttribute("_authState", (Object)InteractionState.State.AUTH.name());
        response.sendRedirect(authorizeUrl);
        return new InteractionState<Object>(InteractionState.State.AUTH, null);
    }

    protected GoogleTokenResponse obtainAccessToken(HttpServletRequest request) throws IOException {
        HttpSession session = request.getSession();
        String stateFromSession = (String)session.getAttribute("_verificationState");
        String stateFromRequest = request.getParameter("state");
        if (stateFromSession == null || stateFromRequest == null || !stateFromSession.equals(stateFromRequest)) {
            throw new OAuthException(OAuthExceptionCode.INVALID_STATE, "Validation of state parameter failed. stateFromSession=" + stateFromSession + ", stateFromRequest=" + stateFromRequest);
        }
        String error = request.getParameter("error");
        if (error != null) {
            if ("access_denied".equals(error)) {
                throw new OAuthException(OAuthExceptionCode.USER_DENIED_SCOPE, error);
            }
            throw new OAuthException(OAuthExceptionCode.UNKNOWN_ERROR, error);
        }
        String code = request.getParameter("code");
        GoogleTokenResponse tokenResponse = new GoogleAuthorizationCodeTokenRequest(this.TRANSPORT, (JsonFactory)this.JSON_FACTORY, this.clientID, this.clientSecret, code, this.redirectURL).execute();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully obtained accessToken from google: " + String.valueOf(tokenResponse)));
        }
        return tokenResponse;
    }

    @Override
    public GoogleAccessTokenContext validateTokenAndUpdateScopes(GoogleAccessTokenContext accessTokenContext) {
        GoogleRequest<Tokeninfo> googleRequest = new GoogleRequest<Tokeninfo>(){

            @Override
            protected Tokeninfo invokeRequest(GoogleAccessTokenContext accessTokenContext) throws IOException {
                GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
                Oauth2 oauth2 = GoogleProcessorImpl.this.getOAuth2InstanceImpl(tokenData);
                GoogleCredential credential = GoogleProcessorImpl.this.getGoogleCredential(tokenData);
                return (Tokeninfo)oauth2.tokeninfo().setAccessToken(credential.getAccessToken()).execute();
            }

            @Override
            protected OAuthException createException(IOException cause) {
                if (cause instanceof HttpResponseException) {
                    return new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Error when obtaining tokenInfo: " + cause.getMessage(), (Throwable)cause);
                }
                return new OAuthException(OAuthExceptionCode.IO_ERROR, "IO Error when obtaining tokenInfo: " + cause.getMessage(), (Throwable)cause);
            }
        };
        Tokeninfo tokenInfo = (Tokeninfo)googleRequest.executeRequest(accessTokenContext, this);
        if (tokenInfo.containsKey((Object)"error")) {
            throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Error during token validation: " + tokenInfo.get((Object)"error").toString());
        }
        if (!tokenInfo.getIssuedTo().equals(this.clientID)) {
            throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Token's client ID does not match app's. clientID from tokenINFO: " + tokenInfo.getIssuedTo());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully validated accessToken from google: " + String.valueOf(tokenInfo)));
        }
        String[] scopes = tokenInfo.getScope().split(" ");
        return new GoogleAccessTokenContext(accessTokenContext.getTokenData(), scopes);
    }

    @Override
    public <C> C getAuthorizedSocialApiObject(GoogleAccessTokenContext accessToken, Class<C> socialApiObjectType) {
        if (Oauth2.class.equals(socialApiObjectType)) {
            return socialApiObjectType.cast(this.getOAuth2Instance(accessToken));
        }
        if (Plus.class.equals(socialApiObjectType)) {
            return socialApiObjectType.cast(this.getPlusService(accessToken));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Class '" + String.valueOf(socialApiObjectType) + "' not supported by this processor"));
        }
        return null;
    }

    @Override
    public Userinfo obtainUserInfo(GoogleAccessTokenContext accessTokenContext) {
        final Oauth2 oauth2 = this.getOAuth2Instance(accessTokenContext);
        GoogleRequest<Userinfo> googleRequest = new GoogleRequest<Userinfo>(){

            @Override
            protected Userinfo invokeRequest(GoogleAccessTokenContext accessTokenContext) throws IOException {
                return (Userinfo)oauth2.userinfo().v2().me().get().execute();
            }

            @Override
            protected OAuthException createException(IOException cause) {
                if (cause instanceof HttpResponseException) {
                    return new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Error when obtaining userInfo: " + cause.getMessage(), (Throwable)cause);
                }
                return new OAuthException(OAuthExceptionCode.IO_ERROR, "IO Error when obtaining userInfo: " + cause.getMessage(), (Throwable)cause);
            }
        };
        Userinfo uinfo = (Userinfo)googleRequest.executeRequest(accessTokenContext, this);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully obtained userInfo from google: " + String.valueOf(uinfo)));
        }
        return uinfo;
    }

    @Override
    public Oauth2 getOAuth2Instance(GoogleAccessTokenContext accessTokenContext) {
        GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
        return this.getOAuth2InstanceImpl(tokenData);
    }

    protected Oauth2 getOAuth2InstanceImpl(GoogleTokenResponse tokenData) {
        GoogleCredential credential = this.getGoogleCredential(tokenData);
        return new Oauth2.Builder(this.TRANSPORT, (JsonFactory)this.JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(this.applicationName).build();
    }

    @Override
    public Plus getPlusService(GoogleAccessTokenContext accessTokenContext) {
        GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
        GoogleCredential credential = this.getGoogleCredential(tokenData);
        Plus service = new Plus.Builder(this.TRANSPORT, (JsonFactory)this.JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(this.applicationName).build();
        return service;
    }

    private GoogleCredential getGoogleCredential(GoogleTokenResponse tokenResponse) {
        return new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.JSON_FACTORY).setTransport(this.TRANSPORT).setClientSecrets(this.clientID, this.clientSecret).build().setFromTokenResponse((TokenResponse)tokenResponse);
    }

    @Override
    public void saveAccessTokenAttributesToUserProfile(UserProfile userProfile, OAuthCodec codec, GoogleAccessTokenContext accessToken) {
        GoogleTokenResponse tokenData = accessToken.getTokenData();
        String encodedAccessToken = codec.encodeString(tokenData.getAccessToken());
        String encodedRefreshToken = codec.encodeString(tokenData.getRefreshToken());
        String encodedScope = codec.encodeString(accessToken.getScopesAsString());
        OAuthPersistenceUtils.saveLongAttribute(encodedAccessToken, userProfile, "user.social-info.google.accessToken", false, this.chunkLength);
        userProfile.setAttribute("user.social-info.google.scope", encodedScope);
        if (encodedRefreshToken != null) {
            OAuthPersistenceUtils.saveLongAttribute(encodedRefreshToken, userProfile, "user.social-info.google.refreshToken", false, this.chunkLength);
        }
    }

    @Override
    public GoogleAccessTokenContext getAccessTokenFromUserProfile(UserProfile userProfile, OAuthCodec codec) {
        String encodedAccessToken = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.google.accessToken", false);
        String decodedAccessToken = codec.decodeString(encodedAccessToken);
        if (decodedAccessToken == null) {
            return null;
        }
        String encodedRefreshToken = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.google.refreshToken", false);
        String decodedRefreshToken = codec.decodeString(encodedRefreshToken);
        String decodedScope = codec.decodeString(userProfile.getAttribute("user.social-info.google.scope"));
        GoogleTokenResponse grc = new GoogleTokenResponse();
        grc.setAccessToken(decodedAccessToken);
        grc.setRefreshToken(decodedRefreshToken);
        grc.setTokenType("Bearer");
        grc.setExpiresInSeconds(Long.valueOf(1000L));
        grc.setIdToken("someTokenId");
        return new GoogleAccessTokenContext(grc, decodedScope);
    }

    @Override
    public void removeAccessTokenFromUserProfile(UserProfile userProfile) {
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.google.accessToken", false);
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.google.refreshToken", false);
        userProfile.setAttribute("user.social-info.google.scope", null);
    }

    @Override
    public void revokeToken(GoogleAccessTokenContext accessTokenContext) throws OAuthException {
        GoogleRequest<Void> googleRequest = new GoogleRequest<Void>(){

            @Override
            protected Void invokeRequest(GoogleAccessTokenContext accessTokenContext) throws IOException {
                GoogleProcessorImpl.this.revokeTokenImpl(accessTokenContext.getTokenData());
                return null;
            }

            @Override
            protected OAuthException createException(IOException cause) {
                return new OAuthException(OAuthExceptionCode.TOKEN_REVOCATION_FAILED, "Error when revoking token", (Throwable)cause);
            }
        };
        googleRequest.executeRequest(accessTokenContext, this);
    }

    private void revokeTokenImpl(GoogleTokenResponse tokenData) throws IOException {
        this.TRANSPORT.createRequestFactory().buildGetRequest(new GenericUrl("https://accounts.google.com/o/oauth2/revoke?token=" + tokenData.getAccessToken())).execute();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Revoked token " + String.valueOf(tokenData)));
        }
    }

    @Override
    public void refreshToken(GoogleAccessTokenContext accessTokenContext) {
        GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
        if (tokenData.getRefreshToken() == null) {
            throw new OAuthException(OAuthExceptionCode.GOOGLE_ERROR, "Given GoogleTokenResponse does not contain refreshToken");
        }
        try {
            GoogleRefreshTokenRequest refreshTokenRequest = new GoogleRefreshTokenRequest(this.TRANSPORT, (JsonFactory)this.JSON_FACTORY, tokenData.getRefreshToken(), this.clientID, this.clientSecret);
            GoogleTokenResponse refreshed = refreshTokenRequest.execute();
            tokenData.setAccessToken(refreshed.getAccessToken());
            if (log.isTraceEnabled()) {
                log.trace((Object)("AccessToken refreshed successfully with value " + refreshed.getAccessToken()));
            }
        }
        catch (IOException ioe) {
            throw new OAuthException(OAuthExceptionCode.GOOGLE_ERROR, (Throwable)ioe);
        }
    }

    private void addScopesFromString(String scope, Set<String> scopes) {
        String[] scopes2;
        for (String current : scopes2 = scope.split(" ")) {
            scopes.add(current);
        }
    }
}

