/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.service;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeChangeNotifier;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeManager;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.NodeStore;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.NavigationStorage;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NavigationServiceImpl
implements NavigationService {
    private static final Log LOG = ExoLogger.getLogger(NavigationServiceImpl.class);
    private final NodeManager nodeManager;
    final ListenerService listenerService;
    final NavigationStorage navigationStorage;

    public NavigationServiceImpl(ListenerService listenerService, NavigationStorage navigationStorage) {
        this.listenerService = listenerService;
        this.navigationStorage = navigationStorage;
        this.nodeManager = new NodeManager((NodeStore)navigationStorage);
    }

    public NavigationContext loadNavigation(SiteKey key) {
        NavigationData navigationData = this.navigationStorage.loadNavigationData(key);
        return navigationData == null ? null : new NavigationContext(navigationData);
    }

    public void saveNavigation(NavigationContext navigation) {
        boolean created = this.loadNavigation(navigation.getKey()) == null;
        this.navigationStorage.saveNavigation(navigation.getKey(), navigation.getState());
        navigation.setData(this.navigationStorage.loadNavigationData(navigation.getKey()));
        navigation.setState(null);
        if (created) {
            this.notify("org.exoplatform.portal.mop.navigation.navigation_created", navigation.getKey());
        } else {
            this.notify("org.exoplatform.portal.mop.navigation.navigation_updated", navigation.getKey());
        }
    }

    public boolean destroyNavigation(NavigationContext navigation) {
        if (navigation == null) {
            throw new IllegalArgumentException("NavigationContext is mandatory");
        }
        if (navigation.getData() == null) {
            throw new IllegalArgumentException("NavigationContext.data removed");
        }
        this.notify("org.exoplatform.portal.mop.navigation.navigation_destroy", navigation.getKey());
        if (this.navigationStorage.destroyNavigation(navigation.getData())) {
            navigation.setData(null);
            this.notify("org.exoplatform.portal.mop.navigation.navigation_destroyed", navigation.getKey());
            return true;
        }
        return false;
    }

    public boolean destroyNavigation(SiteKey siteKey) {
        NavigationContext navigationContext = this.loadNavigation(siteKey);
        if (navigationContext == null) {
            return false;
        }
        return this.destroyNavigation(navigationContext);
    }

    public NodeContext<NodeContext<?>> loadNode(SiteKey siteKey) {
        return this.loadNode(siteKey, null);
    }

    public NodeContext<NodeContext<?>> loadNode(SiteKey siteKey, String navUri) {
        String name;
        NodeContext node;
        if (siteKey == null) {
            return null;
        }
        NavigationContext navigation = this.loadNavigation(siteKey);
        if (navigation == null) {
            return null;
        }
        if (StringUtils.isBlank((String)navUri)) {
            return this.loadNode(NodeModel.SELF_MODEL, navigation, Scope.ALL, null);
        }
        String[] pathTreeParts = StringUtils.trim((String)navUri).split("/");
        Iterator<String> iterator = Arrays.asList(pathTreeParts).iterator();
        for (node = this.loadNode(NodeModel.SELF_MODEL, navigation, GenericScope.branchShape((String[])pathTreeParts, (Scope)Scope.ALL), null); iterator.hasNext() && node != null; node = node.get(name)) {
            name = iterator.next();
        }
        return node;
    }

    public <N> NodeContext<N> loadNode(NodeModel<N> model, NavigationContext navigation, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        if (model == null) {
            throw new NullPointerException("No null model accepted");
        }
        if (navigation == null) {
            throw new NullPointerException("No null navigation accepted");
        }
        if (scope == null) {
            throw new NullPointerException("No null scope accepted");
        }
        String nodeId = navigation.getData().getRootId();
        if (nodeId != null) {
            return this.nodeManager.loadNode(model, nodeId, scope, (NodeChangeListener)new NodeChangeNotifier(listener, (NavigationService)this, this.listenerService));
        }
        return null;
    }

    public <N> NodeContext<N> loadNodeById(NodeModel<N> model, String nodeId, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        if (model == null) {
            throw new NullPointerException("No null model accepted");
        }
        if (nodeId == null) {
            throw new NullPointerException("No null node id accepted");
        }
        if (scope == null) {
            throw new NullPointerException("No null scope accepted");
        }
        return this.nodeManager.loadNode(model, nodeId, scope, (NodeChangeListener)new NodeChangeNotifier(listener, (NavigationService)this, this.listenerService));
    }

    public <N> void updateNode(NodeContext<N> root, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        this.nodeManager.updateNode(root, scope, (NodeChangeListener)new NodeChangeNotifier(listener, (NavigationService)this, this.listenerService));
    }

    public <N> void saveNode(NodeContext<N> context) {
        this.saveNode(context, null);
    }

    public <N> void saveNode(NodeContext<N> context, NodeChangeListener<NodeContext<N>> listener) {
        this.nodeManager.saveNode(context, (NodeChangeListener)new NodeChangeNotifier(listener, (NavigationService)this, this.listenerService));
    }

    public <N> void rebaseNode(NodeContext<N> context, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        this.nodeManager.rebaseNode(context, scope, (NodeChangeListener)new NodeChangeNotifier(listener, (NavigationService)this, this.listenerService));
    }

    public NodeData getNodeById(Long nodeId) {
        return this.navigationStorage.loadNode(nodeId);
    }

    public void moveNode(Long targetId, Long fromId, Long toId, Long previousId) {
        this.navigationStorage.moveNode(targetId, fromId, toId, previousId);
    }

    public void deleteNode(Long nodeId) {
        this.navigationStorage.destroyNode(nodeId);
    }

    public NodeData[] createNode(Long parentId, Long previousId, String name, NodeState state) {
        return this.navigationStorage.createNode(parentId, previousId, name, state);
    }

    public void updateNode(Long nodeId, NodeState state) {
        this.navigationStorage.updateNode(nodeId, state);
    }

    private void notify(String name, SiteKey key) {
        try {
            this.listenerService.broadcast(name, (Object)this, (Object)key);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when delivering notification " + name + " for navigation " + String.valueOf(key)), (Throwable)e);
        }
    }
}

