/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanEditDocFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNtFileFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={OpenDocumentActionListener.class})})
public class OpenDocumentManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotTrashHomeNodeFilter(), new IsNotInTrashFilter(), new IsNotEditingDocumentFilter(), new IsNtFileFilter(), new CanEditDocFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class OpenDocumentActionListener
    extends UIActionBarActionListener<OpenDocumentManageComponent> {
        public void processEvent(Event<OpenDocumentManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((OpenDocumentManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            String objId = event.getRequestContext().getRequestParameter("objectId");
            Node currentNode = null;
            if (objId != null) {
                String _ws = objId.split(":")[0];
                String _nodePath = objId.split(":")[1];
                Session _session = uiExplorer.getSessionByWorkspace(_ws);
                currentNode = uiExplorer.getNodeByPath(_nodePath, _session);
            } else {
                currentNode = uiExplorer.getCurrentNode();
            }
            Utils.openDocumentInDesktop((Node)currentNode, (UIPopupContainer)((UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class)), event);
        }
    }
}

