/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.continuation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.Seti;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.mortbay.cometd.continuation.EXoContinuationClient;
import org.mortbay.cometd.continuation.EXoContinuationCometdServlet;
import org.picocontainer.Disposable;

public class EXoContinuationBayeux
extends BayeuxServerImpl
implements Disposable {
    private static Map<String, String> userToken = new HashMap<String, String>();
    private static Map<String, Set<String>> clientIDs = Collections.synchronizedMap(new LinkedHashMap());
    private String cometdContextName = "cometd";
    private String cloudIDSeparator = "/";
    private ServerSessionImpl systemClient;
    private Seti seti;
    private Oort oort;
    private ServletConfig servletConfig;
    private static final Log LOG = ExoLogger.getLogger(EXoContinuationBayeux.class);

    public EXoContinuationBayeux() {
        this.setSecurityPolicy(new EXoSecurityPolicy(this));
        EXoContinuationCometdServlet servlet = EXoContinuationCometdServlet.getInstance();
        if (servlet != null) {
            servlet.setContainer(ExoContainerContext.getCurrentContainer());
            servlet.reInit();
        }
    }

    public ServerSession newRemoteClient() {
        ServerSessionImpl client = this.newServerSession();
        return client;
    }

    @Deprecated
    public void setTimeout(long timeout) {
    }

    public long getTimeout() {
        return this.getOption("timeout", 30000L);
    }

    public String getCometdContextName() {
        return this.cometdContextName;
    }

    public void setCometdContextName(String context) {
        this.cometdContextName = context;
    }

    long getRandom(long variation) {
        long l = this.randomLong() ^ variation;
        return l < 0L ? -l : l;
    }

    public String getUserToken(String eXoId) {
        if (userToken.containsKey(eXoId)) {
            return userToken.get(eXoId);
        }
        String token = Long.toString(this.getRandom((long)System.identityHashCode((Object)this) ^ System.currentTimeMillis()), 36);
        userToken.put(eXoId, token);
        return token;
    }

    @Deprecated
    public EXoContinuationClient getClientByEXoId(String eXoID) {
        List ids = this.getSessions();
        for (ServerSession client : ids) {
            EXoContinuationClient exoClient;
            if (!(client instanceof EXoContinuationClient) || (exoClient = (EXoContinuationClient)client).getEXoId() == null || !exoClient.getEXoId().equals(eXoID)) continue;
            return exoClient;
        }
        return null;
    }

    public boolean isSubscribed(String eXoID, String clientID) {
        return clientIDs.get(eXoID) != null && clientIDs.get(eXoID).contains(clientID);
    }

    public boolean isPresent(String eXoID) {
        return this.seti.isPresent(eXoID);
    }

    public void sendBroadcastMessage(String channel, Object data, String msgId) {
        ServerSessionImpl fromClient = this.getSystemClient();
        ServerChannel ch = this.getChannel(channel);
        if (ch != null) {
            ch.publish((Session)fromClient, data, Promise.noop());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Send broadcast message " + data.toString() + " on channel " + channel));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Message " + data.toString() + " not send. Channel " + channel + " not exist!"));
        }
    }

    public void sendMessage(String eXoID, String channel, Object data, String id) {
        this.seti.sendMessage(eXoID, channel, data);
    }

    public void setSeti(Seti seti) {
        this.seti = seti;
    }

    public void setOort(Oort oort) {
        this.oort = oort;
    }

    public void setCloudIDSeparator(String cloudIDSeparator) {
        if (cloudIDSeparator != null) {
            this.cloudIDSeparator = cloudIDSeparator;
        } else {
            LOG.warn((Object)"Can't set null for cloudIDSeparator");
        }
    }

    private ServerSessionImpl getSystemClient() {
        if (this.systemClient == null) {
            this.systemClient = this.newServerSession();
        }
        return this.systemClient;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setServletConfig(ServletConfig config) {
        this.servletConfig = config;
    }

    public void dispose() {
        for (ServerSession session : this.getSessions()) {
            ((ServerSessionImpl)session).destroyScheduler();
        }
        if (this.seti != null && this.oort != null) {
            try {
                this.seti.stop();
                this.oort.stop();
                super.stop();
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Set<String> getConnectedUserIds() {
        return clientIDs.keySet();
    }

    public static class EXoSecurityPolicy
    implements SecurityPolicy,
    ServerSession.RemovedListener {
        private EXoContinuationBayeux bayeux;

        public EXoSecurityPolicy(EXoContinuationBayeux bayeux) {
            this.bayeux = bayeux;
        }

        private boolean checkUser(ServerMessage message) {
            String userId = (String)message.get((Object)"exoId");
            String eXoToken = (String)message.get((Object)"exoToken");
            return userId != null && userToken.containsKey(userId) && userToken.get(userId).equals(eXoToken);
        }

        public boolean canCreate(BayeuxServer server, ServerSession client, String channelId, ServerMessage message) {
            Boolean b = client != null && !ChannelId.isMeta((String)channelId);
            return b;
        }

        public boolean canHandshake(BayeuxServer server, ServerSession client, ServerMessage message) {
            if (client.isLocalSession() || this.bayeux.oort.isOortHandshake((Message)message)) {
                return true;
            }
            if (this.checkUser(message)) {
                client.addListener((ServerSession.ServerSessionListener)this);
                String eXoID = (String)message.get((Object)"exoId");
                Set<String> cIds = clientIDs.get(eXoID);
                if (cIds == null) {
                    cIds = ConcurrentHashMap.newKeySet();
                    clientIDs.put(eXoID, cIds);
                }
                this.bayeux.seti.associate(eXoID, client);
                cIds.add(client.getId());
                return true;
            }
            return false;
        }

        public boolean canPublish(BayeuxServer server, ServerSession client, ServerChannel channel, ServerMessage message) {
            return client != null;
        }

        public boolean canSubscribe(BayeuxServer server, ServerSession client, ServerChannel channel, ServerMessage message) {
            return client != null && (this.checkUser(message) || client.isLocalSession() || this.bayeux.oort.isOort(client));
        }

        public void removed(ServerSession session, ServerMessage message, boolean timeout) {
            Iterator<Map.Entry<String, Set<String>>> iter = clientIDs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Set<String>> client = iter.next();
                Set<String> ids = client.getValue();
                ids.remove(session.getId());
                if (!ids.isEmpty()) continue;
                iter.remove();
            }
        }
    }
}

