/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.FieldInjector;
import org.exoplatform.services.rest.impl.method.ParameterHelper;
import org.exoplatform.services.rest.impl.method.ParameterResolver;
import org.exoplatform.services.rest.impl.method.ParameterResolverFactory;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;

public class FieldInjectorImpl
implements FieldInjector {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.FieldInjectorImpl");
    private final Annotation[] annotations;
    private final Annotation annotation;
    private final String defaultValue;
    private final boolean encoded;
    private final Field jfield;
    private final Method setter;

    public FieldInjectorImpl(Class<?> resourceClass, Field jfield) {
        this.jfield = jfield;
        this.annotations = jfield.getDeclaredAnnotations();
        this.setter = FieldInjectorImpl.getSetter(resourceClass, jfield);
        Annotation annotation = null;
        String defaultValue = null;
        boolean encoded = false;
        boolean provider = resourceClass.getAnnotation(Provider.class) != null;
        List<String> allowedAnnotation = provider ? ParameterHelper.PROVIDER_FIELDS_ANNOTATIONS : ParameterHelper.RESOURCE_FIELDS_ANNOTATIONS;
        for (Annotation a : this.annotations) {
            Class<? extends Annotation> ac = a.annotationType();
            if (allowedAnnotation.contains(ac.getName())) {
                if (annotation == null) {
                    annotation = a;
                    continue;
                }
                String msg = "JAX-RS annotations on one of fields " + jfield.toString() + " are equivocality. Annotations: " + annotation.toString() + " and " + a.toString() + " can't be applied to one field.";
                throw new RuntimeException(msg);
            }
            if (ac == Encoded.class && !provider) {
                encoded = true;
                continue;
            }
            if (ac != DefaultValue.class || provider) continue;
            defaultValue = ((DefaultValue)a).value();
        }
        this.defaultValue = defaultValue;
        this.annotation = annotation;
        this.encoded = encoded || resourceClass.getAnnotation(Encoded.class) != null;
    }

    private static Method getSetter(final Class<?> clazz, final Field jfield) {
        Method setter;
        block2: {
            setter = null;
            try {
                setter = (Method)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws NoSuchMethodException {
                        String name = jfield.getName();
                        String setterName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
                        return clazz.getMethod(setterName, jfield.getType());
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return setter;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class<?> getParameterClass() {
        return this.jfield.getType();
    }

    @Override
    public Type getGenericType() {
        return this.jfield.getGenericType();
    }

    @Override
    public boolean isEncoded() {
        return this.encoded;
    }

    @Override
    public String getName() {
        return this.jfield.getName();
    }

    @Override
    public void inject(Object resource, ApplicationContext context) {
        if (this.annotation != null) {
            ParameterResolver pr = ParameterResolverFactory.createParameterResolver(this.annotation);
            try {
                if (this.setter != null) {
                    this.setter.invoke(resource, pr.resolve(this, context));
                }
                if (!Modifier.isPublic(this.jfield.getModifiers())) {
                    SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            FieldInjectorImpl.this.jfield.setAccessible(true);
                            return null;
                        }
                    });
                }
                this.jfield.set(resource, pr.resolve(this, context));
            }
            catch (Exception e) {
                Class<? extends Annotation> ac = this.annotation.annotationType();
                if (ac == MatrixParam.class || ac == QueryParam.class || ac == PathParam.class) {
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                }
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            }
        } else {
            Object tmp = context.getDependencySupplier().getComponent(this);
            if (tmp != null) {
                try {
                    if (this.setter != null) {
                        this.setter.invoke(resource, tmp);
                    } else {
                        if (!Modifier.isPublic(this.jfield.getModifiers())) {
                            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                                @Override
                                public Void run() {
                                    FieldInjectorImpl.this.jfield.setAccessible(true);
                                    return null;
                                }
                            });
                        }
                        this.jfield.set(resource, tmp);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
                }
                catch (IllegalArgumentException e) {
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
                }
                catch (InvocationTargetException e) {
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
                }
            }
        }
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitFieldInjector(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ FieldInjectorImpl: ");
        sb.append("annotation: " + String.valueOf(this.getAnnotation())).append("; type: " + String.valueOf(this.getParameterClass())).append("; generic-type : " + String.valueOf(this.getGenericType())).append("; default-value: " + this.getDefaultValue()).append("; encoded: " + this.isEncoded()).append(" ]");
        return sb.toString();
    }
}

