/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class KudosSentNotificationListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(KudosSentNotificationListener.class);

    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        Kudos kudos = (Kudos)event.getData();
        try {
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            ctx.append(Utils.KUDOS_DETAILS_PARAMETER, (Object)kudos);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"KudosActivityReceiverNotificationPlugin"))).execute(ctx);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error sending notification for Kudos with id " + kudos.getTechnicalId()), (Throwable)e);
        }
    }
}

