/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.AccountTemporaryLockedException;
import org.exoplatform.services.organization.DisabledUserException;
import org.exoplatform.services.organization.ExtendedUserHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.auth.AuthenticatorPlugin;
import org.exoplatform.services.organization.plugin.SecurityCheckAuthenticationPlugin;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.DigestPasswordEncrypter;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.security.MembershipHashSet;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.PasswordEncrypter;
import org.exoplatform.services.security.RolesExtractor;
import org.exoplatform.services.security.UsernameCredential;

public class OrganizationAuthenticatorImpl
implements Authenticator {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.api.OrganizationUserRegistry");
    private final ThreadLocal<Exception> lastExceptionOnValidateUser = new ThreadLocal();
    private final OrganizationService orgService;
    private final PasswordEncrypter encrypter;
    private final RolesExtractor rolesExtractor;
    private final ListenerService listenerService;
    private List<AuthenticatorPlugin> plugins = new ArrayList<AuthenticatorPlugin>();
    private List<SecurityCheckAuthenticationPlugin> securityCheckPlugins = new ArrayList<SecurityCheckAuthenticationPlugin>();

    public OrganizationAuthenticatorImpl(OrganizationService orgService, RolesExtractor rolesExtractor, PasswordEncrypter encrypter, ListenerService listenerService) {
        this.orgService = orgService;
        this.encrypter = encrypter;
        this.rolesExtractor = rolesExtractor;
        this.listenerService = listenerService;
    }

    public OrganizationAuthenticatorImpl(OrganizationService orgService, RolesExtractor rolesExtractor, ListenerService listenerService) {
        this(orgService, rolesExtractor, null, listenerService);
    }

    public OrganizationAuthenticatorImpl(OrganizationService orgService, ListenerService listenerService) {
        this(orgService, null, null, listenerService);
    }

    public OrganizationService getOrganizationService() {
        return this.orgService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity createIdentity(String userId) throws Exception {
        Collection memberships;
        MembershipHashSet entries = new MembershipHashSet();
        this.begin(this.orgService);
        try {
            memberships = this.orgService.getMembershipHandler().findMembershipsByUser(userId);
        }
        finally {
            this.end(this.orgService);
        }
        if (memberships != null) {
            for (Membership membership : memberships) {
                entries.add(new MembershipEntry(membership.getGroupId(), membership.getMembershipType()));
            }
        }
        Identity identity = null;
        identity = this.rolesExtractor == null ? new Identity(userId, (Collection)entries) : new Identity(userId, (Collection)entries, (Collection)this.rolesExtractor.extractRoles(userId, (Set)entries));
        return identity;
    }

    public String validateUser(Credential[] credentials) throws LoginException, Exception {
        String username = null;
        String password = null;
        Map passwordContext = null;
        for (Credential credential : credentials) {
            if (credential instanceof UsernameCredential) {
                username = ((UsernameCredential)credential).getUsername();
            }
            if (!(credential instanceof PasswordCredential)) continue;
            password = ((PasswordCredential)credential).getPassword();
            passwordContext = ((PasswordCredential)credential).getPasswordContext();
        }
        boolean success = false;
        if (username != null && password != null) {
            if (this.encrypter != null) {
                password = new String(this.encrypter.encrypt(password.getBytes()));
            }
            this.begin(this.orgService);
            try {
                UserHandler userHandler = this.orgService.getUserHandler();
                if (userHandler.findUserByName(username) != null) {
                    for (SecurityCheckAuthenticationPlugin securityCheckAuthenticationPlugin : this.getSecurityCheckPlugins()) {
                        securityCheckAuthenticationPlugin.doCheck(userHandler.findUserByName(username));
                    }
                }
                if (passwordContext != null && userHandler instanceof ExtendedUserHandler) {
                    DigestPasswordEncrypter pe = new DigestPasswordEncrypter(username, passwordContext);
                    success = ((ExtendedUserHandler)userHandler).authenticate(username, password, (PasswordEncrypter)pe);
                } else {
                    success = userHandler.authenticate(username, password);
                }
                this.lastExceptionOnValidateUser.remove();
                if (!success) {
                    for (AuthenticatorPlugin authenticatorPlugin : this.getPlugins()) {
                        try {
                            String validatedUserName = authenticatorPlugin.validateUser(credentials);
                            if (!StringUtils.isNotBlank((String)validatedUserName)) continue;
                            success = true;
                            username = validatedUserName;
                            break;
                        }
                        catch (Exception e) {
                            LOG.debug("Error while authenticating user using plugin {}", new Object[]{authenticatorPlugin.getClass()});
                        }
                    }
                }
                for (SecurityCheckAuthenticationPlugin securityCheckAuthenticationPlugin : this.getSecurityCheckPlugins()) {
                    if (!success) {
                        if (username != null) {
                            securityCheckAuthenticationPlugin.onCheckFail(username);
                            throw new LoginException("Login failed for " + username.replace("\n", " ").replace("\r", " "));
                        }
                        throw new LoginException("Login failed for " + username);
                    }
                    securityCheckAuthenticationPlugin.onCheckSuccess(username);
                }
            }
            catch (DisabledUserException e) {
                this.lastExceptionOnValidateUser.set((Exception)((Object)e));
                throw new LoginException("The user account " + username.replace("\n", " ").replace("\r", " ") + " is disabled");
            }
            catch (AccountTemporaryLockedException e) {
                this.lastExceptionOnValidateUser.set((Exception)((Object)e));
                throw new LoginException("The user account " + username.replace("\n", " ").replace("\r", " ") + " is temporarily locked until " + String.valueOf(e.getUnlockTime()));
            }
            catch (Exception e) {
                this.lastExceptionOnValidateUser.set(e);
                throw e;
            }
            finally {
                this.end(this.orgService);
            }
        }
        if (!success) {
            throw new LoginException("Login failed for " + username);
        }
        this.listenerService.broadcast("exo.user.authenticated", (Object)this.orgService, (Object)username);
        return username;
    }

    public void addAuthenticatorPlugin(AuthenticatorPlugin plugin) {
        this.plugins.add(plugin);
    }

    public void addSecurityCheckAuthenticatorPlugin(SecurityCheckAuthenticationPlugin plugin) {
        this.securityCheckPlugins.add(plugin);
    }

    public List<AuthenticatorPlugin> getPlugins() {
        return this.plugins;
    }

    public List<SecurityCheckAuthenticationPlugin> getSecurityCheckPlugins() {
        return this.securityCheckPlugins;
    }

    public void setPlugins(List<AuthenticatorPlugin> plugins) {
        this.plugins = plugins;
    }

    public void begin(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    public void end(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }

    public Exception getLastExceptionOnValidateUser() {
        Exception e = this.lastExceptionOnValidateUser.get();
        if (e != null) {
            this.lastExceptionOnValidateUser.remove();
        }
        return e;
    }
}

