/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.listener;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.PortletApplication;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationStore;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;

public class DocumentsSpaceApplicationListener
implements SpaceLifeCycleListener {
    private static final String[] DOCUMENTS_SIZE_GADGET_ACCESS_PERMISSIONS = new String[]{"Everyone"};
    public static final String DOCUMENTS_GADGET_INSTALLED_EVENT_NAME = "documents.space.application.installed";
    public static final String DOCUMENTS_GADGET_UNINSTALLED_EVENT_NAME = "documents.space.application.uniinstalled";
    public static final String SPACE_HOME_EXTENSIBLE_CONTAINER_ID = "SpaceHomePortlets";
    public static final String DOCUMENTS_GADGET_NAME = "documents";
    public static final String DOCUMENTS_DOCUMENTS_PORTLET_ID = "Documents";
    public static final String DOCUMENTS_DOCUMENTS_SIZE_PORTLET_ID = "DocumentsSizeGadget";
    public static final String DOCUMENTS_DOCUMENTS_SIZE_COMPLETE_ID = "documents/DocumentsSizeGadget";
    private static final Log LOG = ExoLogger.getLogger(DocumentsSpaceApplicationListener.class);
    private ListenerService listenerService;
    private SpaceTemplateService spaceTemplateService;
    private NavigationService navigationService;
    private NavigationStore navigationStore;
    private DataStorage dataStorage;

    public void applicationAdded(SpaceLifeCycleEvent event) {
        this.installDocumentsSizeGadget(event);
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
        this.installDocumentsSizeGadget(event);
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
        this.uninstallDocumentsSizeGadget(event);
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
        this.uninstallDocumentsSizeGadget(event);
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        boolean documentAppInstalled;
        Space space = event.getSpace();
        SpaceTemplate spaceTemplate = this.getSpaceTemplateService().getSpaceTemplateByName(space.getTemplate());
        if (spaceTemplate != null && spaceTemplate.getSpaceApplicationList() != null && (documentAppInstalled = spaceTemplate.getSpaceApplicationList().stream().anyMatch(app -> StringUtils.equals((CharSequence)app.getPortletName(), (CharSequence)DOCUMENTS_DOCUMENTS_PORTLET_ID)))) {
            try {
                this.installDocumentsSizeGadget(space, event.getType());
            }
            catch (Exception e) {
                LOG.warn("Error installing AgendaTimeline widget in space {}", new Object[]{space.getDisplayName(), e});
            }
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }

    private void installDocumentsSizeGadget(SpaceLifeCycleEvent event) {
        String appId = event.getTarget();
        if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.equals((CharSequence)this.getPortletId(appId), (CharSequence)DOCUMENTS_DOCUMENTS_PORTLET_ID)) {
            Space space = event.getSpace();
            try {
                this.installDocumentsSizeGadget(space, event.getType());
            }
            catch (Exception e) {
                LOG.warn("Error installing Documents Size Gadget in space {}", new Object[]{space.getDisplayName(), e});
            }
        }
    }

    private void installDocumentsSizeGadget(Space space, SpaceLifeCycleEvent.Type type) throws Exception {
        boolean applicationExists = this.documentsSizeGadgetAddedInHomePage(space);
        if (!applicationExists) {
            Page spaceHomePage = this.getSpaceHomePage(space);
            if (spaceHomePage == null) {
                return;
            }
            Container extensibleSpaceHomeContainer = this.getExtensibleSpaceHomeContainer(spaceHomePage.getChildren());
            if (extensibleSpaceHomeContainer != null) {
                extensibleSpaceHomeContainer.getChildren().add(DocumentsSpaceApplicationListener.getDocumentsSizeGadgetModel());
                this.getDataStorage().save(spaceHomePage);
                DocumentsSpaceApplicationListener.broadcastEvent(this.getListenerService(), DOCUMENTS_GADGET_INSTALLED_EVENT_NAME, space, type);
            }
        }
    }

    private void uninstallDocumentsSizeGadget(SpaceLifeCycleEvent event) {
        String appId = event.getTarget();
        if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.equals((CharSequence)this.getPortletId(appId), (CharSequence)DOCUMENTS_DOCUMENTS_PORTLET_ID)) {
            try {
                this.uninstallDocumentsSizeGadget(event.getSpace(), event.getType());
            }
            catch (Exception e) {
                LOG.warn("Error uninstalling Documents Size Gadget from space {}", new Object[]{event.getSpace().getDisplayName(), e});
            }
        }
    }

    private boolean documentsSizeGadgetAddedInHomePage(Space space) throws Exception {
        Page page = this.getSpaceHomePage(space);
        if (page == null) {
            LOG.info("Can't find home page content of space '{}', the  Documents Size Gadget will not be installed in Space Home page", new Object[]{space.getDisplayName()});
            return false;
        }
        ArrayList childObjects = page.getChildren();
        return this.documentsSizeGadgetExists(childObjects);
    }

    private void uninstallDocumentsSizeGadget(Space space, SpaceLifeCycleEvent.Type type) throws Exception {
        ArrayList children;
        boolean removed;
        Page spaceHomePage = this.getSpaceHomePage(space);
        if (spaceHomePage == null) {
            return;
        }
        Container extensibleSpaceHomeContainer = this.getExtensibleSpaceHomeContainer(spaceHomePage.getChildren());
        if (extensibleSpaceHomeContainer != null && (removed = this.removeDocumentsSizeGadget(children = extensibleSpaceHomeContainer.getChildren()))) {
            this.getDataStorage().save(spaceHomePage);
            DocumentsSpaceApplicationListener.broadcastEvent(this.getListenerService(), DOCUMENTS_GADGET_UNINSTALLED_EVENT_NAME, space, type);
        }
    }

    private boolean documentsSizeGadgetExists(ArrayList<ModelObject> childObjects) throws Exception {
        for (ModelObject modelObject : childObjects) {
            if (modelObject instanceof Container) {
                ArrayList subChildren = ((Container)modelObject).getChildren();
                return this.documentsSizeGadgetExists(subChildren);
            }
            if (!(modelObject instanceof Application)) continue;
            Application application = (Application)modelObject;
            ApplicationState state = application.getState();
            String applicationId = this.getDataStorage().getId(state);
            if (!StringUtils.equals((CharSequence)DOCUMENTS_DOCUMENTS_SIZE_COMPLETE_ID, (CharSequence)applicationId)) continue;
            return true;
        }
        return false;
    }

    private Container getExtensibleSpaceHomeContainer(ArrayList<ModelObject> childObjects) throws Exception {
        if (childObjects == null || childObjects.isEmpty()) {
            return null;
        }
        for (ModelObject modelObject : childObjects) {
            if (!(modelObject instanceof Container)) continue;
            Container container = (Container)modelObject;
            if (StringUtils.equals((CharSequence)SPACE_HOME_EXTENSIBLE_CONTAINER_ID, (CharSequence)container.getId())) {
                return container;
            }
            Container extensibleContainer = this.getExtensibleSpaceHomeContainer(container.getChildren());
            if (extensibleContainer == null) continue;
            return extensibleContainer;
        }
        return null;
    }

    private boolean removeDocumentsSizeGadget(ArrayList<ModelObject> childObjects) throws Exception {
        if (childObjects == null || childObjects.isEmpty()) {
            return false;
        }
        boolean removed = false;
        Iterator<ModelObject> childObjectsIterator = childObjects.iterator();
        while (childObjectsIterator.hasNext()) {
            ModelObject modelObject = childObjectsIterator.next();
            if (modelObject instanceof Application) {
                Application application = (Application)modelObject;
                ApplicationState state = application.getState();
                String applicationId = this.getDataStorage().getId(state);
                if (!StringUtils.equals((CharSequence)DOCUMENTS_DOCUMENTS_SIZE_COMPLETE_ID, (CharSequence)applicationId)) continue;
                childObjectsIterator.remove();
                removed = true;
                continue;
            }
            if (!(modelObject instanceof Container)) continue;
            ArrayList subChildren = ((Container)modelObject).getChildren();
            removed = this.removeDocumentsSizeGadget(subChildren);
        }
        return removed;
    }

    private Page getSpaceHomePage(Space space) {
        Page homePage = this.getSpaceHomePageBySpaceTemplate(space);
        if (homePage != null) {
            return homePage;
        }
        return this.getSpaceHomePageFromNavigation(space);
    }

    private Page getSpaceHomePageFromNavigation(Space space) {
        String spaceDisplayName = space.getDisplayName();
        NavigationContext navigation = this.getNavigationService().loadNavigation(SiteKey.group((String)space.getGroupId()));
        if (navigation == null || navigation.getData() == null || navigation.getData().getRootId() == null) {
            LOG.debug("Can't find home page of space '{}', the  Documents Size Gadget will not be installed in Space Home page", new Object[]{spaceDisplayName});
            return null;
        }
        String rootId = navigation.getData().getRootId();
        PageKey homePageKey = this.getHomePageRef(rootId, spaceDisplayName);
        if (homePageKey == null) {
            LOG.debug("Can't find home page reference of space '{}', the  Documents Size Gadget will not be installed in Space Home page", new Object[]{spaceDisplayName});
            return null;
        }
        return this.getDataStorage().getPage(homePageKey.format());
    }

    private Page getSpaceHomePageBySpaceTemplate(Space space) {
        SpaceTemplate spaceTemplate = this.getSpaceTemplateService().getSpaceTemplateByName(space.getTemplate());
        if (spaceTemplate != null && spaceTemplate.getSpaceHomeApplication() != null) {
            String homePageName = spaceTemplate.getSpaceHomeApplication().getPortletName();
            PageKey homePageKey = new PageKey(SiteKey.group((String)space.getGroupId()), homePageName);
            return this.getDataStorage().getPage(homePageKey.format());
        }
        return null;
    }

    private PageKey getHomePageRef(String rootId, String spaceDisplayName) {
        NodeData node = this.getNavigationStore().loadNode(Long.valueOf(Safe.parseLong((String)rootId)));
        if (node == null) {
            LOG.debug("Can't find home page of space '{}', the  Documents Size Gadget will not be installed in Space Home page", new Object[]{spaceDisplayName});
            return null;
        }
        if (node.getState() != null && node.getState().getPageRef() != null) {
            return node.getState().getPageRef();
        }
        Iterator nodes = node.iterator(false);
        while (nodes.hasNext()) {
            String childId = (String)nodes.next();
            PageKey homePageKey = this.getHomePageRef(childId, spaceDisplayName);
            if (homePageKey == null) continue;
            return homePageKey;
        }
        return null;
    }

    private String getPortletId(String appId) {
        int SEPARATOR = 46;
        if (appId.indexOf(46) != -1) {
            int beginIndex = appId.lastIndexOf(46) + 1;
            int endIndex = appId.length();
            return appId.substring(beginIndex, endIndex);
        }
        return appId;
    }

    private NavigationStore getNavigationStore() {
        if (this.navigationStore == null) {
            this.navigationStore = (NavigationStore)ExoContainerContext.getService(NavigationStore.class);
        }
        return this.navigationStore;
    }

    private NavigationService getNavigationService() {
        if (this.navigationService == null) {
            this.navigationService = (NavigationService)ExoContainerContext.getService(NavigationService.class);
        }
        return this.navigationService;
    }

    private DataStorage getDataStorage() {
        if (this.dataStorage == null) {
            this.dataStorage = (DataStorage)ExoContainerContext.getService(DataStorage.class);
        }
        return this.dataStorage;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)ExoContainerContext.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    private SpaceTemplateService getSpaceTemplateService() {
        if (this.spaceTemplateService == null) {
            this.spaceTemplateService = (SpaceTemplateService)ExoContainerContext.getService(SpaceTemplateService.class);
        }
        return this.spaceTemplateService;
    }

    private static Application<Portlet> getDocumentsSizeGadgetModel() {
        PortletApplication model = new PortletApplication();
        PortletState state = new PortletState((ApplicationState)new TransientApplicationState(DOCUMENTS_DOCUMENTS_SIZE_COMPLETE_ID), ApplicationType.PORTLET);
        model.setState(state.getApplicationState());
        model.setTitle(DOCUMENTS_DOCUMENTS_SIZE_PORTLET_ID);
        model.setShowInfoBar(false);
        model.setShowApplicationState(false);
        model.setShowApplicationMode(false);
        model.setAccessPermissions(DOCUMENTS_SIZE_GADGET_ACCESS_PERMISSIONS);
        model.setModifiable(true);
        return model;
    }

    public static void broadcastEvent(ListenerService listenerService, String eventName, Object source, Object data) {
        try {
            listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error broadcasting event '" + eventName + "' using source '" + String.valueOf(source) + "' and data " + String.valueOf(data)), (Throwable)e);
        }
    }
}

