/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.onlyoffice.OnlyofficeEditorServiceImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DocumentTypePlugin
extends BaseComponentPlugin {
    protected static final Log LOG = ExoLogger.getLogger(DocumentTypePlugin.class);
    private static final String DOCUMENT_TYPES_CONFIGURATION = "document-types-configuration";
    protected List<String> mimeTypes = Collections.emptyList();

    public DocumentTypePlugin(InitParams initParams) {
        ObjectParameter typesParam = initParams.getObjectParam(DOCUMENT_TYPES_CONFIGURATION);
        if (typesParam != null) {
            Object obj = typesParam.getObject();
            if (obj != null && OnlyofficeEditorServiceImpl.DocumentTypesConfig.class.isAssignableFrom(obj.getClass())) {
                this.mimeTypes = ((OnlyofficeEditorServiceImpl.DocumentTypesConfig)OnlyofficeEditorServiceImpl.DocumentTypesConfig.class.cast(obj)).getMimeTypes();
            } else {
                this.mimeTypes = new ArrayList<String>();
                LOG.error((Object)"The mimetypes are not set");
            }
        }
    }

    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }
}

