/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class BatchFetchQueue {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = CoreLogging.logger(BatchFetchQueue.class);
    private final @UnknownKeyFor @NonNull @Initialized PersistenceContext context;
    private @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized EntityKey, @UnknownKeyFor @NonNull @Initialized SubselectFetch> subselectsByEntityKey;
    private @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized LinkedHashSet<@UnknownKeyFor @NonNull @Initialized EntityKey>> batchLoadableEntityKeys;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized LinkedHashMap<@UnknownKeyFor @NonNull @Initialized CollectionEntry, @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> batchLoadableCollections;

    public BatchFetchQueue(@UnknownKeyFor @NonNull @Initialized PersistenceContext context) {
        this.context = context;
    }

    public void clear() {
        this.batchLoadableEntityKeys = null;
        this.batchLoadableCollections = null;
        this.subselectsByEntityKey = null;
    }

    public @Nullable @UnknownKeyFor @Initialized SubselectFetch getSubselect(@UnknownKeyFor @NonNull @Initialized EntityKey key) {
        if (this.subselectsByEntityKey == null) {
            return null;
        }
        return this.subselectsByEntityKey.get(key);
    }

    public void addSubselect(@UnknownKeyFor @NonNull @Initialized EntityKey key, @UnknownKeyFor @NonNull @Initialized SubselectFetch subquery) {
        SubselectFetch previous;
        if (this.subselectsByEntityKey == null) {
            this.subselectsByEntityKey = CollectionHelper.mapOfSize(12);
        }
        if ((previous = this.subselectsByEntityKey.put(key, subquery)) != null && LOG.isDebugEnabled()) {
            LOG.debugf("SubselectFetch previously registered with BatchFetchQueue for `%s#s`", (Object)key.getEntityName(), key.getIdentifier());
        }
    }

    public void removeSubselect(@UnknownKeyFor @NonNull @Initialized EntityKey key) {
        if (this.subselectsByEntityKey != null) {
            this.subselectsByEntityKey.remove(key);
        }
    }

    public void addBatchLoadableEntityKey(@UnknownKeyFor @NonNull @Initialized EntityKey key) {
        if (key.isBatchLoadable(this.context.getSession().getLoadQueryInfluencers())) {
            if (this.batchLoadableEntityKeys == null) {
                this.batchLoadableEntityKeys = CollectionHelper.mapOfSize(12);
            }
            LinkedHashSet keysForEntity = this.batchLoadableEntityKeys.computeIfAbsent(key.getEntityName(), k -> CollectionHelper.linkedSetOfSize(8));
            keysForEntity.add(key);
        }
    }

    public void removeBatchLoadableEntityKey(@UnknownKeyFor @NonNull @Initialized EntityKey key) {
        LinkedHashSet<EntityKey> set;
        if (key.isBatchLoadable(this.context.getSession().getLoadQueryInfluencers()) && this.batchLoadableEntityKeys != null && (set = this.batchLoadableEntityKeys.get(key.getEntityName())) != null) {
            set.remove(key);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean containsEntityKey(@UnknownKeyFor @NonNull @Initialized EntityKey key) {
        LinkedHashSet<EntityKey> set;
        if (key.isBatchLoadable(this.context.getSession().getLoadQueryInfluencers()) && this.batchLoadableEntityKeys != null && (set = this.batchLoadableEntityKeys.get(key.getEntityName())) != null) {
            return set.contains(key);
        }
        return false;
    }

    public <T> void collectBatchLoadableEntityIds(@UnknownKeyFor @NonNull @Initialized int domainBatchSize, @UnknownKeyFor @NonNull @Initialized IndexedConsumer<T> collector, @NonNull T loadingId, @UnknownKeyFor @NonNull @Initialized EntityMappingType entityDescriptor) {
        collector.accept(0, loadingId);
        if (this.batchLoadableEntityKeys == null) {
            return;
        }
        LinkedHashSet<EntityKey> set = this.batchLoadableEntityKeys.get(entityDescriptor.getEntityName());
        if (set == null) {
            return;
        }
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        int batchPosition = 1;
        int end = -1;
        boolean checkForEnd = false;
        for (EntityKey key : set) {
            if (checkForEnd && batchPosition == end) {
                return;
            }
            if (identifierMapping.areEqual(loadingId, key.getIdentifier(), this.context.getSession())) {
                end = batchPosition;
            } else if (!this.isCached(key, entityDescriptor.getEntityPersister())) {
                collector.accept(batchPosition++, key.getIdentifier());
            }
            if (batchPosition != domainBatchSize) continue;
            batchPosition = 1;
            if (end == -1) continue;
            checkForEnd = true;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] getBatchLoadableEntityIds(@UnknownKeyFor @NonNull @Initialized EntityMappingType entityDescriptor, @UnknownKeyFor @NonNull @Initialized Object loadingId, @UnknownKeyFor @NonNull @Initialized int maxBatchSize) {
        Object[] ids = new Object[maxBatchSize];
        ids[0] = loadingId;
        if (this.batchLoadableEntityKeys == null) {
            return ids;
        }
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        LinkedHashSet<EntityKey> set = this.batchLoadableEntityKeys.get(entityDescriptor.getEntityName());
        if (set != null) {
            for (EntityKey key : set) {
                if (checkForEnd && i == end) {
                    return ids;
                }
                if (entityDescriptor.getEntityPersister().getIdentifierType().isEqual(loadingId, key.getIdentifier())) {
                    end = i;
                } else if (!this.isCached(key, entityDescriptor.getEntityPersister())) {
                    ids[i++] = key.getIdentifier();
                }
                if (i != maxBatchSize) continue;
                i = 1;
                if (end == -1) continue;
                checkForEnd = true;
            }
        }
        return ids;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isCached(@UnknownKeyFor @NonNull @Initialized EntityKey entityKey, @UnknownKeyFor @NonNull @Initialized EntityPersister persister) {
        SharedSessionContractImplementor session = this.context.getSession();
        if (this.context.getSession().getCacheMode().isGetEnabled() && persister.canReadFromCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(entityKey.getIdentifier(), persister, session.getFactory(), session.getTenantIdentifier());
            return CacheHelper.fromSharedCache(session, key, persister, (CachedDomainDataAccess)cache) != null;
        }
        return false;
    }

    public void addBatchLoadableCollection(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection, @UnknownKeyFor @NonNull @Initialized CollectionEntry ce) {
        CollectionPersister persister = ce.getLoadedPersister();
        if (this.batchLoadableCollections == null) {
            this.batchLoadableCollections = CollectionHelper.mapOfSize(12);
        }
        assert (persister != null) : "@AssumeAssertion(nullness)";
        LinkedHashMap map = this.batchLoadableCollections.computeIfAbsent(persister.getRole(), k -> CollectionHelper.linkedMapOfSize(16));
        map.put(ce, collection);
    }

    public void removeBatchLoadableCollection(@UnknownKeyFor @NonNull @Initialized CollectionEntry ce) {
        CollectionPersister persister = ce.getLoadedPersister();
        if (this.batchLoadableCollections == null) {
            return;
        }
        assert (persister != null) : "@AssumeAssertion(nullness)";
        LinkedHashMap<CollectionEntry, PersistentCollection<?>> map = this.batchLoadableCollections.get(persister.getRole());
        if (map != null) {
            map.remove(ce);
        }
    }

    public <T> void collectBatchLoadableCollectionKeys(@UnknownKeyFor @NonNull @Initialized int batchSize, @UnknownKeyFor @NonNull @Initialized IndexedConsumer<T> collector, @NonNull T keyBeingLoaded, @UnknownKeyFor @NonNull @Initialized PluralAttributeMapping pluralAttributeMapping) {
        collector.accept(0, keyBeingLoaded);
        if (this.batchLoadableCollections == null) {
            return;
        }
        LinkedHashMap<CollectionEntry, PersistentCollection<?>> map = this.batchLoadableCollections.get(pluralAttributeMapping.getNavigableRole().getFullPath());
        if (map == null) {
            return;
        }
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        for (Map.Entry<CollectionEntry, PersistentCollection<?>> me : map.entrySet()) {
            CollectionEntry ce = me.getKey();
            Object loadedKey = ce.getLoadedKey();
            PersistentCollection<?> collection = me.getValue();
            if (loadedKey == null) continue;
            if (collection.wasInitialized()) {
                LOG.warn((Object)"Encountered initialized collection in BatchFetchQueue, this should not happen.");
                continue;
            }
            if (checkForEnd && i == end) {
                return;
            }
            boolean isEqual = pluralAttributeMapping.getKeyDescriptor().areEqual(keyBeingLoaded, loadedKey, this.context.getSession());
            if (isEqual) {
                end = i;
            } else if (!this.isCached(loadedKey, pluralAttributeMapping.getCollectionDescriptor())) {
                collector.accept(i++, loadedKey);
            }
            if (i != batchSize) continue;
            i = 1;
            if (end == -1) continue;
            checkForEnd = true;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] getCollectionBatch(@UnknownKeyFor @NonNull @Initialized CollectionPersister collectionPersister, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized int batchSize) {
        Object[] keys = new Object[batchSize];
        keys[0] = id;
        if (this.batchLoadableCollections == null) {
            return keys;
        }
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        LinkedHashMap<CollectionEntry, PersistentCollection<?>> map = this.batchLoadableCollections.get(collectionPersister.getRole());
        if (map != null) {
            for (Map.Entry<CollectionEntry, PersistentCollection<?>> me : map.entrySet()) {
                CollectionEntry ce = me.getKey();
                Object loadedKey = ce.getLoadedKey();
                PersistentCollection<?> collection = me.getValue();
                if (loadedKey == null) continue;
                if (collection.wasInitialized()) {
                    LOG.warn((Object)"Encountered initialized collection in BatchFetchQueue, this should not happen.");
                    continue;
                }
                if (checkForEnd && i == end) {
                    return keys;
                }
                boolean isEqual = collectionPersister.getKeyType().isEqual(id, loadedKey, collectionPersister.getFactory());
                if (isEqual) {
                    end = i;
                } else if (!this.isCached(loadedKey, collectionPersister)) {
                    keys[i++] = loadedKey;
                }
                if (i != batchSize) continue;
                i = 1;
                if (end == -1) continue;
                checkForEnd = true;
            }
        }
        return keys;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isCached(@UnknownKeyFor @NonNull @Initialized Object collectionKey, @UnknownKeyFor @NonNull @Initialized CollectionPersister persister) {
        SharedSessionContractImplementor session = this.context.getSession();
        if (session.getCacheMode().isGetEnabled() && persister.hasCache()) {
            CollectionDataAccess cache = persister.getCacheAccessStrategy();
            Object cacheKey = cache.generateCacheKey(collectionKey, persister, session.getFactory(), session.getTenantIdentifier());
            return CacheHelper.fromSharedCache(session, cacheKey, persister, (CachedDomainDataAccess)cache) != null;
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor getSession() {
        return this.context.getSession();
    }
}

