/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.BooleanNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.ByteArrayNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.CalendarNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.DoubleNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.LongNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.NameNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.PathNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.PermissionNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.ReferenceNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.StreamNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.StringNewValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TransientValueData
implements ValueData {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.TransientValueData");
    protected AbstractValueData delegate;

    public TransientValueData(int orderNumber, InputStream stream, SpoolFile spoolFile, SpoolConfig spoolConfig) throws IOException {
        this.delegate = new StreamNewValueData(orderNumber, stream, spoolFile, spoolConfig);
    }

    public TransientValueData(InputStream stream, SpoolConfig spoolConfig) throws IOException {
        this(0, stream, null, spoolConfig);
    }

    public TransientValueData(int orderNumber, InputStream stream, SpoolConfig spoolConfig) throws IOException {
        this(orderNumber, stream, null, spoolConfig);
    }

    public TransientValueData(byte[] value) {
        this.delegate = new ByteArrayNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, byte[] value) {
        this.delegate = new ByteArrayNewValueData(orderNumber, value);
    }

    public TransientValueData(String value) {
        this.delegate = new StringNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, String value) {
        this.delegate = new StringNewValueData(orderNumber, value);
    }

    public TransientValueData(boolean value) {
        this.delegate = new BooleanNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, boolean value) {
        this.delegate = new BooleanNewValueData(orderNumber, value);
    }

    public TransientValueData(Calendar value) {
        this.delegate = new CalendarNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, Calendar value) {
        this.delegate = new CalendarNewValueData(orderNumber, value);
    }

    public TransientValueData(double value) {
        this.delegate = new DoubleNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, double value) {
        this.delegate = new DoubleNewValueData(orderNumber, value);
    }

    public TransientValueData(long value) {
        this.delegate = new LongNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, long value) {
        this.delegate = new LongNewValueData(orderNumber, value);
    }

    public TransientValueData(InternalQName value) {
        this.delegate = new NameNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, InternalQName value) {
        this.delegate = new NameNewValueData(orderNumber, value);
    }

    public TransientValueData(QPath value) {
        this.delegate = new PathNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, QPath value) {
        this.delegate = new PathNewValueData(orderNumber, value);
    }

    public TransientValueData(Identifier value) {
        this.delegate = new ReferenceNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, Identifier value) {
        this.delegate = new ReferenceNewValueData(orderNumber, value);
    }

    public TransientValueData(AccessControlEntry value) {
        this.delegate = new PermissionNewValueData(0, value);
    }

    public TransientValueData(int orderNumber, AccessControlEntry value) {
        this.delegate = new PermissionNewValueData(orderNumber, value);
    }

    protected TransientValueData() {
    }

    @Override
    public byte[] getAsByteArray() throws IllegalStateException, IOException {
        return this.delegate.getAsByteArray();
    }

    @Override
    public InputStream getAsStream() throws IOException {
        return this.delegate.getAsStream();
    }

    @Override
    public long getLength() {
        return this.delegate.getLength();
    }

    @Override
    public boolean isByteArray() {
        return this.delegate.isByteArray();
    }

    @Override
    public long read(OutputStream stream, long length, long position) throws IOException {
        return this.delegate.read(stream, length, position);
    }

    @Override
    public int getOrderNumber() {
        return this.delegate.getOrderNumber();
    }

    public void delegate(AbstractValueData newValue) {
        this.delegate = newValue;
    }

    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return this.delegate.createPersistedCopy(orderNumber);
    }

    @Override
    public boolean equals(ValueData another) {
        if (this == another) {
            return true;
        }
        return this.delegate.equals(another);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueData) {
            return this.equals((ValueData)obj);
        }
        return false;
    }
}

