/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.recovery;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.login.onboarding.OnboardingHandler;
import org.exoplatform.web.login.recovery.ChangePasswordConnector;
import org.exoplatform.web.login.recovery.PasswordRecoveryHandler;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.register.ExternalRegisterHandler;
import org.exoplatform.web.security.PortalToken;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class PasswordRecoveryServiceImpl
implements PasswordRecoveryService {
    public static final String AUTHENTICATION_ATTEMPTS = "authenticationAttempts";
    protected static Log log = ExoLogger.getLogger(PasswordRecoveryServiceImpl.class);
    private final OrganizationService orgService;
    private final MailService mailService;
    private final ResourceBundleService bundleService;
    private final RemindPasswordTokenService remindPasswordTokenService;
    private final CookieTokenService cookieTokenService;
    private final BrandingService brandingService;
    private final WebAppController webController;
    public static final String CONFIGURED_DOMAIN_URL_KEY = "gatein.email.domain.url";
    private String changePasswordConnectorName;
    private Map<String, ChangePasswordConnector> changePasswordConnectorMap;
    private static final Pattern PATTERN = Pattern.compile("&\\{([a-zA-Z0-9\\.]+)\\}");

    public PasswordRecoveryServiceImpl(InitParams initParams, OrganizationService orgService, MailService mailService, ResourceBundleService bundleService, RemindPasswordTokenService remindPasswordTokenService, CookieTokenService cookieTokenService, WebAppController controller, BrandingService brandingService) {
        this.orgService = orgService;
        this.mailService = mailService;
        this.bundleService = bundleService;
        this.remindPasswordTokenService = remindPasswordTokenService;
        this.cookieTokenService = cookieTokenService;
        this.webController = controller;
        this.brandingService = brandingService;
        this.changePasswordConnectorMap = new HashMap<String, ChangePasswordConnector>();
        this.changePasswordConnectorName = initParams.getValueParam("changePasswordConnector").getValue();
    }

    public void addConnector(ChangePasswordConnector connector) {
        if (!this.changePasswordConnectorMap.containsKey(connector.getName())) {
            this.changePasswordConnectorMap.put(connector.getName(), connector);
        }
    }

    public String verifyToken(String tokenId, String type) {
        PortalToken token = this.remindPasswordTokenService.getToken(tokenId, type);
        if (token == null || token.isExpired()) {
            return null;
        }
        return token.getUsername();
    }

    public void deleteToken(String tokenId, String type) {
        this.remindPasswordTokenService.deleteToken(tokenId, type);
    }

    public String verifyToken(String tokenId) {
        return this.verifyToken(tokenId, "");
    }

    public boolean allowChangePassword(String username) throws Exception {
        User user = this.orgService.getUserHandler().findUserByName(username);
        return user != null && (user.isInternalStore() || this.changePasswordConnectorMap.get(this.changePasswordConnectorName).isAllowChangeExternalPassword());
    }

    public boolean changePass(String tokenId, String tokenType, String username, String password) {
        try {
            UserProfile profile;
            this.changePasswordConnectorMap.get(this.changePasswordConnectorName).changePassword(username, password);
            try {
                this.remindPasswordTokenService.deleteToken(tokenId, tokenType);
                this.remindPasswordTokenService.deleteTokensByUsernameAndType(username, tokenType);
                this.cookieTokenService.deleteTokensByUsernameAndType(username, "");
            }
            catch (Exception ex) {
                log.warn((Object)("Can not delete token: " + tokenId), (Throwable)ex);
            }
            User user = this.orgService.getUserHandler().findUserByName(username);
            if (user != null && (profile = this.orgService.getUserProfileHandler().findUserProfileByName(username)) != null && profile.getAttribute(AUTHENTICATION_ATTEMPTS) != null && !profile.getAttribute(AUTHENTICATION_ATTEMPTS).equals("0")) {
                profile.setAttribute(AUTHENTICATION_ATTEMPTS, String.valueOf(0));
                this.orgService.getUserProfileHandler().saveUserProfile(profile, true);
            }
            return true;
        }
        catch (Exception ex) {
            log.error((Object)("Can not change pass for user: " + username), (Throwable)ex);
            return false;
        }
    }

    public boolean sendOnboardingEmail(User user, Locale locale, StringBuilder url) {
        if (user == null) {
            throw new IllegalArgumentException("User or Locale must not be null");
        }
        ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
        String tokenId = this.remindPasswordTokenService.createToken(user.getUserName(), "onboard");
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append((CharSequence)url);
        redirectUrl.append("/on-boarding");
        redirectUrl.append("?lang=" + I18N.toTagIdentifier((Locale)locale));
        redirectUrl.append("&token=" + tokenId);
        String emailBody = this.buildOnboardingEmailBody(user, bundle, redirectUrl.toString());
        String emailSubject = bundle.getString("onboarding.email.header") + " " + this.brandingService.getCompanyName();
        String senderName = MailUtils.getSenderName();
        Object from = MailUtils.getSenderEmail();
        if (senderName != null && !senderName.trim().isEmpty()) {
            from = senderName + " <" + (String)from + ">";
        }
        Message message = new Message();
        message.setFrom((String)from);
        message.setTo(user.getEmail());
        message.setSubject(emailSubject);
        message.setBody(emailBody);
        message.setMimeType("text/html");
        try {
            this.mailService.sendMessage(message);
        }
        catch (Exception ex) {
            log.error((Object)"Failure to send onboarding email", (Throwable)ex);
            return false;
        }
        return true;
    }

    private String buildOnboardingEmailBody(User user, ResourceBundle bundle, String link) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/onBoarding_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replaceAll("\\$\\{USER_DISPLAY_NAME\\}", user == null ? "" : user.getDisplayName());
        content = content.replaceAll("\\$\\{COMPANY_NAME\\}", this.brandingService.getCompanyName());
        content = content.replaceAll("\\$\\{RESET_PASSWORD_LINK\\}", link);
        return content;
    }

    public String sendExternalRegisterEmail(String sender, String email, Locale locale, String space, StringBuilder url) throws Exception {
        return this.sendExternalRegisterEmail(sender, email, locale, space, url, true);
    }

    public String sendExternalRegisterEmail(String sender, String email, Locale locale, String space, StringBuilder url, boolean spaceInvitation) throws Exception {
        String emailSubject;
        String emailBody;
        ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
        String token = this.createToken(email);
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append((CharSequence)url);
        redirectUrl.append("/external-registration");
        redirectUrl.append("?lang=" + I18N.toTagIdentifier((Locale)locale));
        redirectUrl.append("&token=" + token);
        if (spaceInvitation) {
            UserHandler uHandler = this.orgService.getUserHandler();
            String senderFullName = uHandler.findUserByName(sender).getDisplayName();
            emailBody = this.buildExternalEmailBody(senderFullName, space, redirectUrl.toString(), bundle);
            emailSubject = senderFullName + " " + bundle.getString("external.email.subject") + " " + this.brandingService.getCompanyName() + (String)(space != null ? " : " + space : "");
        } else {
            emailBody = this.buildOnboardingEmailBody(null, bundle, redirectUrl.toString());
            emailSubject = bundle.getString("onboarding.email.header") + " " + this.brandingService.getCompanyName();
        }
        String senderName = MailUtils.getSenderName();
        Object from = MailUtils.getSenderEmail();
        if (senderName != null && !senderName.trim().isEmpty()) {
            from = senderName + " <" + (String)from + ">";
        }
        Message message = new Message();
        message.setFrom((String)from);
        message.setTo(email);
        message.setSubject(emailSubject);
        message.setBody(emailBody);
        message.setMimeType("text/html");
        this.mailService.sendMessage(message);
        return token;
    }

    private String createToken(String email) {
        return this.remindPasswordTokenService.createToken(email, "external-registration");
    }

    private String buildExternalEmailBody(String sender, String space, String link, ResourceBundle bundle) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/external_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replaceAll("\\$\\{SENDER_DISPLAY_NAME\\}", sender);
        content = content.replaceAll("\\$\\{COMPANY_NAME\\}", this.brandingService.getCompanyName());
        content = content.replaceAll("\\$\\{SPACE_DISPLAY_NAME\\}", space);
        content = content.replaceAll("\\$\\{EXTERNAL_REGISTRATION_LINK\\}", link);
        return content;
    }

    public boolean sendAccountVerificationEmail(String data, String username, String firstName, String lastName, String email, Locale locale, StringBuilder url) {
        try {
            ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
            String tokenId = this.remindPasswordTokenService.createToken(data, "email-validation");
            StringBuilder redirectUrl = new StringBuilder();
            redirectUrl.append((CharSequence)url);
            redirectUrl.append("/").append("external-registration");
            redirectUrl.append("?action=validateEmail");
            redirectUrl.append("&token=" + tokenId);
            String emailBody = this.buildExternalVerificationAccountEmailBody(firstName + " " + lastName, username, redirectUrl.toString(), bundle);
            String emailSubject = bundle.getString("external.verification.account.email.subject") + " " + this.brandingService.getCompanyName() + "!";
            String senderName = MailUtils.getSenderName();
            Object from = MailUtils.getSenderEmail();
            if (senderName != null && !senderName.trim().isEmpty()) {
                from = senderName + " <" + (String)from + ">";
            }
            Message message = new Message();
            message.setFrom((String)from);
            message.setTo(email);
            message.setSubject(emailSubject);
            message.setBody(emailBody);
            message.setMimeType("text/html");
            this.mailService.sendMessage(message);
        }
        catch (Exception ex) {
            log.error((Object)"Failure to send external confirmation account email", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean sendAccountCreatedConfirmationEmail(String username, Locale locale, StringBuilder url) {
        try {
            User user = this.orgService.getUserHandler().findUserByName(username);
            ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
            StringBuilder redirectUrl = new StringBuilder();
            redirectUrl.append((CharSequence)url);
            redirectUrl.append("/login");
            String emailBody = this.buildExternalConfirmationAccountEmailBody(user.getDisplayName(), user.getUserName(), redirectUrl.toString(), bundle);
            String emailSubject = bundle.getString("external.confirmation.account.email.subject") + " " + this.brandingService.getCompanyName() + "!";
            String senderName = MailUtils.getSenderName();
            Object from = MailUtils.getSenderEmail();
            if (senderName != null && !senderName.trim().isEmpty()) {
                from = senderName + " <" + (String)from + ">";
            }
            Message message = new Message();
            message.setFrom((String)from);
            message.setTo(user.getEmail());
            message.setSubject(emailSubject);
            message.setBody(emailBody);
            message.setMimeType("text/html");
            this.mailService.sendMessage(message);
        }
        catch (Exception ex) {
            log.error((Object)"Failure to send external confirmation account email", (Throwable)ex);
            return false;
        }
        return true;
    }

    private String buildExternalConfirmationAccountEmailBody(String dispalyName, String username, String link, ResourceBundle bundle) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/external_confirmation_account_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replaceAll("\\$\\{DISPLAY_NAME\\}", dispalyName);
        content = content.replaceAll("\\$\\{COMPANY_NAME\\}", this.brandingService.getCompanyName());
        content = content.replaceAll("\\$\\{USERNAME\\}", username);
        content = content.replaceAll("\\$\\{LOGIN_LINK\\}", link);
        return content;
    }

    private String buildExternalVerificationAccountEmailBody(String dispalyName, String username, String link, ResourceBundle bundle) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/external_verification_account_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replaceAll("\\$\\{DISPLAY_NAME\\}", dispalyName);
        content = content.replaceAll("\\$\\{COMPANY_NAME\\}", this.brandingService.getCompanyName());
        content = content.replaceAll("\\$\\{USERNAME\\}", username);
        content = content.replaceAll("\\$\\{LOGIN_LINK\\}", link);
        return content;
    }

    public boolean sendRecoverPasswordEmail(User user, Locale defaultLocale, HttpServletRequest req) {
        if (user == null) {
            throw new IllegalArgumentException("User or Locale must not be null");
        }
        Locale locale = this.getLocaleOfUser(user.getUserName(), defaultLocale);
        PortalContainer container = PortalContainer.getCurrentInstance((ServletContext)req.getServletContext());
        ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
        String tokenId = this.remindPasswordTokenService.createToken(user.getUserName(), "forgot-password");
        Router router = this.webController.getRouter();
        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
        params.put(WebAppController.HANDLER_PARAM, "forgot-password");
        params.put(PasswordRecoveryHandler.TOKEN, tokenId);
        params.put(PasswordRecoveryHandler.LANG, I18N.toTagIdentifier((Locale)locale));
        StringBuilder url = new StringBuilder();
        url.append(req.getScheme()).append("://").append(req.getServerName());
        if (req.getServerPort() != 80 && req.getServerPort() != 443) {
            url.append(':').append(req.getServerPort());
        }
        url.append(container.getPortalContext().getContextPath());
        url.append(router.render(params));
        String emailBody = this.buildRecoverEmailBody(user, bundle, url.toString());
        String emailSubject = this.getEmailSubject(user, bundle);
        String senderName = MailUtils.getSenderName();
        Object from = MailUtils.getSenderEmail();
        if (senderName != null && !senderName.trim().isEmpty()) {
            from = senderName + " <" + (String)from + ">";
        }
        Message message = new Message();
        message.setFrom((String)from);
        message.setTo(user.getEmail());
        message.setSubject(emailSubject);
        message.setBody(emailBody);
        message.setMimeType("text/html");
        try {
            this.mailService.sendMessage(message);
        }
        catch (Exception ex) {
            log.error((Object)"Failure to send recover password email", (Throwable)ex);
            return false;
        }
        return true;
    }

    private Locale getLocaleOfUser(String username, Locale defLocale) {
        try {
            UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(username);
            String lang = profile == null ? null : (String)profile.getUserInfoMap().get("user.language");
            return lang != null ? LocaleContextInfo.getLocale((String)lang) : defLocale;
        }
        catch (Exception ex) {
            log.debug((Object)"Can not load user profile language", (Throwable)ex);
            return defLocale;
        }
    }

    private String buildRecoverEmailBody(User user, ResourceBundle bundle, String link) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/forgot_password_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replaceAll("\\$\\{FIRST_NAME\\}", user.getFirstName());
        content = content.replaceAll("\\$\\{COMPANY_NAME\\}", this.brandingService.getCompanyName());
        content = content.replaceAll("\\$\\{USERNAME\\}", user.getUserName());
        content = content.replaceAll("\\$\\{RESET_PASSWORD_LINK\\}", link);
        return content;
    }

    private String resolveLanguage(InputStream input, ResourceBundle bundle) {
        StringBuffer content = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                if (content.length() > 0) {
                    content.append("\n");
                }
                this.resolveLanguage(content, line, bundle);
            }
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
        return content.toString();
    }

    private void resolveLanguage(StringBuffer sb, String input, ResourceBundle bundle) {
        Matcher matcher = PATTERN.matcher(input);
        while (matcher.find()) {
            String resource;
            String key = matcher.group(1);
            try {
                resource = bundle.getString(key);
            }
            catch (MissingResourceException ex) {
                resource = key;
            }
            matcher.appendReplacement(sb, resource);
        }
        matcher.appendTail(sb);
    }

    protected String getEmailSubject(User user, ResourceBundle bundle) {
        return bundle.getString("gatein.forgotPassword.email.subject");
    }

    public String getOnboardingURL(String tokenId, String lang) {
        Router router = this.webController.getRouter();
        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
        params.put(WebAppController.HANDLER_PARAM, "on-boarding");
        if (tokenId != null) {
            params.put(OnboardingHandler.TOKEN, tokenId);
        }
        if (lang != null) {
            params.put(OnboardingHandler.LANG, lang);
        }
        return router.render(params);
    }

    public String getExternalRegistrationURL(String tokenId, String lang) {
        Router router = this.webController.getRouter();
        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
        params.put(WebAppController.HANDLER_PARAM, "external-registration");
        if (tokenId != null) {
            params.put(ExternalRegisterHandler.TOKEN, tokenId);
        }
        if (lang != null) {
            params.put(ExternalRegisterHandler.LANG, lang);
        }
        return router.render(params);
    }

    public String getPasswordRecoverURL(String tokenId, String lang) {
        Router router = this.webController.getRouter();
        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
        params.put(WebAppController.HANDLER_PARAM, "forgot-password");
        if (tokenId != null) {
            params.put(PasswordRecoveryHandler.TOKEN, tokenId);
        }
        if (lang != null) {
            params.put(PasswordRecoveryHandler.LANG, lang);
        }
        return router.render(params);
    }

    public ChangePasswordConnector getActiveChangePasswordConnector() {
        return this.changePasswordConnectorMap.get(this.changePasswordConnectorName);
    }
}

