/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.KnnQuery;
import co.elastic.clients.elasticsearch._types.KnnSearch;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch.core.search.FieldCollapse;
import co.elastic.clients.elasticsearch.core.search.Suggester;
import co.elastic.clients.json.JsonData;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.elasticsearch.client.elc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class NativeQuery
extends BaseQuery {
    @Nullable
    private final co.elastic.clients.elasticsearch._types.query_dsl.Query query;
    @Nullable
    private Query springDataQuery;
    @Nullable
    private co.elastic.clients.elasticsearch._types.query_dsl.Query filter;
    private final Map<String, Aggregation> aggregations = new LinkedHashMap<String, Aggregation>();
    @Nullable
    private Suggester suggester;
    @Nullable
    private FieldCollapse fieldCollapse;
    private List<SortOptions> sortOptions = Collections.emptyList();
    private Map<String, JsonData> searchExtensions = Collections.emptyMap();
    @Nullable
    private KnnQuery knnQuery;
    @Nullable
    private List<KnnSearch> knnSearches = Collections.emptyList();

    public NativeQuery(NativeQueryBuilder builder) {
        super(builder);
        this.query = builder.getQuery();
        this.filter = builder.getFilter();
        this.aggregations.putAll(builder.getAggregations());
        this.suggester = builder.getSuggester();
        this.fieldCollapse = builder.getFieldCollapse();
        this.sortOptions = builder.getSortOptions();
        this.searchExtensions = builder.getSearchExtensions();
        if (builder.getSpringDataQuery() != null) {
            Assert.isTrue((!NativeQuery.class.isAssignableFrom(builder.getSpringDataQuery().getClass()) ? 1 : 0) != 0, (String)"Cannot add an NativeQuery in a NativeQuery");
        }
        this.springDataQuery = builder.getSpringDataQuery();
        this.knnQuery = builder.getKnnQuery();
        this.knnSearches = builder.getKnnSearches();
    }

    public NativeQuery(@Nullable co.elastic.clients.elasticsearch._types.query_dsl.Query query) {
        this.query = query;
    }

    public static NativeQueryBuilder builder() {
        return new NativeQueryBuilder();
    }

    @Nullable
    public co.elastic.clients.elasticsearch._types.query_dsl.Query getQuery() {
        return this.query;
    }

    @Nullable
    public co.elastic.clients.elasticsearch._types.query_dsl.Query getFilter() {
        return this.filter;
    }

    public Map<String, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public Suggester getSuggester() {
        return this.suggester;
    }

    @Nullable
    public FieldCollapse getFieldCollapse() {
        return this.fieldCollapse;
    }

    public List<SortOptions> getSortOptions() {
        return this.sortOptions;
    }

    public Map<String, JsonData> getSearchExtensions() {
        return this.searchExtensions;
    }

    public void setSpringDataQuery(@Nullable Query springDataQuery) {
        this.springDataQuery = springDataQuery;
    }

    @Nullable
    public KnnQuery getKnnQuery() {
        return this.knnQuery;
    }

    @Nullable
    public List<KnnSearch> getKnnSearches() {
        return this.knnSearches;
    }

    @Nullable
    public Query getSpringDataQuery() {
        return this.springDataQuery;
    }
}

