/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.dao.condition.Conditions;
import org.exoplatform.task.dao.condition.SingleCondition;
import org.exoplatform.task.dao.jpa.CommonJPADAO;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;

public class TaskDAOImpl
extends CommonJPADAO<Task, Long>
implements TaskHandler {
    private static final Log log = ExoLogger.getExoLogger(TaskDAOImpl.class);
    private static final ListAccess<Task> EMPTY = new ListAccess<Task>(){

        public Task[] load(int index, int length) throws Exception, IllegalArgumentException {
            return new Task[0];
        }

        public int getSize() throws Exception {
            return 0;
        }
    };

    @Override
    public void updateStatus(Status stOld, Status stNew) {
        Query query = this.getEntityManager().createNamedQuery("Task.updateStatus");
        query.setParameter("status_old", (Object)stOld);
        query.setParameter("status_new", (Object)stNew);
        query.executeUpdate();
    }

    @Override
    public List<Task> findByUser(String user) {
        ArrayList<String> memberships = new ArrayList<String>();
        memberships.add(user);
        return this.findAllByMembership(user, memberships);
    }

    @Override
    public List<Task> findAllByMembership(String user, List<String> memberships) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.findByMemberships", Task.class);
        query.setParameter("userName", (Object)user);
        query.setParameter("memberships", memberships);
        return this.cloneEntities(query.getResultList());
    }

    @Override
    public ListAccess<Task> findTasks(TaskQuery query) {
        return this.findEntities(query, Task.class);
    }

    @Override
    public <T> List<T> selectTaskField(TaskQuery query, String fieldName) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery();
        Root task = q.from(Task.class);
        Predicate predicate = this.buildQuery(query.getCondition(), task, cb, q);
        if (predicate != null) {
            q.where((Expression)predicate);
        }
        Path path = null;
        if (fieldName.indexOf(46) != -1) {
            String[] strs = fieldName.split("\\.");
            Join join = null;
            for (int i = 0; i < strs.length - 1; ++i) {
                String s = strs[i];
                join = join == null ? task.join(s) : join.join(s);
            }
            path = join.get(strs[strs.length - 1]);
        } else {
            path = task.get(fieldName);
        }
        if ("coworker".equals(fieldName)) {
            path = task.join(fieldName);
        }
        q.select((Selection)path).distinct(true);
        if (query.getOrderBy() != null && !query.getOrderBy().isEmpty()) {
            List<OrderBy> orderBies = query.getOrderBy();
            ArrayList<Order> orders = new ArrayList<Order>();
            for (OrderBy orderBy : orderBies) {
                if (!orderBy.getFieldName().equals(fieldName)) continue;
                Path p = task.get(orderBy.getFieldName());
                orders.add(orderBy.isAscending() ? cb.asc((Expression)p) : cb.desc((Expression)p));
            }
            if (!orders.isEmpty()) {
                q.orderBy(orders);
            }
        }
        TypedQuery selectQuery = em.createQuery(q);
        return this.cloneEntities(selectQuery.getResultList());
    }

    @Override
    public Task findTaskByActivityId(String activityId) {
        if (activityId == null || activityId.isEmpty()) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createNamedQuery("Task.findTaskByActivityId", Task.class);
        query.setParameter("activityId", (Object)activityId);
        try {
            return this.cloneEntity((Task)query.getSingleResult());
        }
        catch (PersistenceException e) {
            return null;
        }
    }

    @Override
    public void updateTaskOrder(long currentTaskId, Status newStatus, long[] orders) {
        int currentTaskIndex = -1;
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i] != currentTaskId) continue;
            currentTaskIndex = i;
            break;
        }
        if (currentTaskIndex == -1) {
            return;
        }
        Task currentTask = (Task)this.find(currentTaskId);
        currentTask.getCoworker();
        Task prevTask = null;
        Task nextTask = null;
        if (currentTaskIndex < orders.length - 1) {
            prevTask = (Task)this.find(orders[currentTaskIndex + 1]);
        }
        if (currentTaskIndex > 0) {
            nextTask = (Task)this.find(orders[currentTaskIndex - 1]);
        }
        int oldRank = currentTask.getRank();
        int prevRank = prevTask != null ? prevTask.getRank() : 0;
        int nextRank = nextTask != null ? nextTask.getRank() : 0;
        int newRank = prevRank + 1;
        if (newStatus != null && currentTask.getStatus().getId() != newStatus.getId()) {
            oldRank = 0;
            currentTask.setStatus(newStatus);
        }
        EntityManager em = this.getEntityManager();
        StringBuilder sql = null;
        if (newRank == 1 || oldRank == 0) {
            int increment = 1;
            StringBuilder exclude = new StringBuilder();
            if (nextRank == 0) {
                Task task;
                for (int i = currentTaskIndex - 1; i >= 0 && (task = (Task)this.find(orders[i])).getRank() <= 0; --i) {
                    task.getCoworker();
                    task.setRank(newRank + currentTaskIndex - i);
                    this.update(task);
                    if (exclude.length() > 0) {
                        exclude.append(',');
                    }
                    exclude.append(task.getId());
                    ++increment;
                }
            }
            sql = new StringBuilder("UPDATE TaskTask as ta SET ta.rank = ta.rank + ").append(increment).append(" WHERE ta.rank >= ").append(newRank);
            if (exclude.length() > 0) {
                sql.append(" AND ta.id NOT IN (").append(exclude.toString()).append(")");
            }
        } else if (oldRank < newRank) {
            sql = new StringBuilder("UPDATE TaskTask as ta SET ta.rank = ta.rank - 1").append(" WHERE ta.rank > ").append(oldRank).append(" AND ta.rank < ").append(newRank);
            --newRank;
        } else if (oldRank > newRank) {
            sql = new StringBuilder("UPDATE TaskTask as ta SET ta.rank = ta.rank + 1").append(" WHERE ta.rank >= ").append(newRank).append(" AND ta.rank < ").append(oldRank);
            ++newRank;
        }
        if (sql != null && sql.length() > 0) {
            sql.append(" AND ta.completed = FALSE AND ta.status.id = ").append(currentTask.getStatus().getId());
            EntityTransaction trans = em.getTransaction();
            boolean active = false;
            if (!trans.isActive()) {
                trans.begin();
                active = true;
            }
            em.createQuery(sql.toString()).executeUpdate();
            if (active) {
                trans.commit();
            }
        }
        currentTask.setRank(newRank);
        this.update(currentTask);
    }

    @Override
    public ListAccess<Task> findTasksByLabel(long labelId, List<Long> projectIds, String username, OrderBy orderBy) {
        TaskQuery query = new TaskQuery();
        if (projectIds != null) {
            query.setProjectIds(projectIds);
        }
        if (orderBy != null) {
            query.setOrderBy(Arrays.asList(orderBy));
        }
        if (labelId > 0L) {
            query.setLabelIds(Arrays.asList(labelId));
        } else {
            query.setIsLabelOf(username);
        }
        return this.findTasks(query);
    }

    @Override
    public Set<String> getCoworker(long taskid) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.getCoworker", String.class);
        query.setParameter("taskid", (Object)taskid);
        List tags = query.getResultList();
        return new HashSet<String>(tags);
    }

    @Override
    public Task getTaskWithCoworkers(long id) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.getTaskWithCoworkers", Task.class);
        query.setParameter("taskid", (Object)id);
        try {
            return this.cloneEntity((Task)query.getSingleResult());
        }
        catch (PersistenceException e) {
            log.error((Object)("Error when fetching task " + id + " with coworkers"), (Throwable)e);
            return null;
        }
    }

    @Override
    protected Path buildPath(SingleCondition condition, Root<Task> root) {
        String field = condition.getField();
        Join join = null;
        Path path = null;
        if (Conditions.TASK_PROJECT.equals(condition.getField())) {
            path = root.join("status", JoinType.LEFT).get("project").get("id");
        } else if (Conditions.TASK_MANAGER.equals(condition.getField())) {
            path = root.join("status", JoinType.LEFT).join("project", JoinType.LEFT).join("manager", JoinType.LEFT);
        } else if (Conditions.TASK_PARTICIPATOR.equals(condition.getField())) {
            path = root.join("status", JoinType.LEFT).join("project", JoinType.LEFT).join("participator", JoinType.LEFT);
        } else if (Conditions.TASK_MENTIONED_USERS.equals(condition.getField())) {
            path = root.join("comments", JoinType.LEFT).join("mentionedUsers", JoinType.LEFT);
        } else {
            if (field.indexOf(46) > 0) {
                String[] arr = field.split("\\.");
                for (int i = 0; i < arr.length - 1; ++i) {
                    String s = arr[i];
                    join = join == null ? root.join(s, JoinType.INNER) : join.join(s, JoinType.INNER);
                }
                field = arr[arr.length - 1];
            }
            Path path2 = path = join == null ? root.get(field) : join.get(field);
        }
        if (Conditions.TASK_COWORKER.equals(field)) {
            path = root.join(field, JoinType.LEFT);
        }
        return path;
    }

    @Override
    public List<Task> getUncompletedTasks(String user, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.getUncompletedTasks", Task.class);
        query.setParameter("userName", (Object)user);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.cloneEntities(query.getResultList());
    }

    @Override
    public Long countUncompletedTasks(String user) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.countUncompletedTasks", Long.class);
        query.setParameter("userName", (Object)user);
        Long result = (Long)query.getSingleResult();
        return result == null ? 0L : result;
    }

    @Override
    public List<Task> getWatchedTasks(String user, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.getWatchedTasks", Task.class);
        query.setParameter("userName", (Object)user);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.cloneEntities(query.getResultList());
    }

    @Override
    public Long countWatchedTasks(String user) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.countWatchedTasks", Long.class);
        query.setParameter("userName", (Object)user);
        Long result = (Long)query.getSingleResult();
        return result == null ? 0L : result;
    }

    @Override
    public List<Task> getCollaboratedTasks(String user, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.getCollaboratedTasks", Task.class);
        query.setParameter("userName", (Object)user);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.cloneEntities(query.getResultList());
    }

    @Override
    public Long countCollaboratedTasks(String user) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.countCollaboratedTasks", Long.class);
        query.setParameter("userName", (Object)user);
        Long result = (Long)query.getSingleResult();
        return result == null ? 0L : result;
    }

    @Override
    public List<Task> getAssignedTasks(String user, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.getAssignedTasks", Task.class);
        query.setParameter("userName", (Object)user);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.cloneEntities(query.getResultList());
    }

    @Override
    public Long countAssignedTasks(String user) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.countAssignedTasks", Long.class);
        query.setParameter("userName", (Object)user);
        Long result = (Long)query.getSingleResult();
        return result == null ? 0L : result;
    }

    @Override
    public List<Task> getByStatus(long statusid) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.getByStatus", Task.class);
        query.setParameter("statusid", (Object)statusid);
        return this.cloneEntities(query.getResultList());
    }

    @Override
    public ListAccess<Task> getIncomingTasks(String user) {
        TaskQuery q = new TaskQuery();
        q.setIsIncomingOf(user);
        q.setCompleted(false);
        return this.findTasks(q);
    }

    @Override
    public List<Task> getOverdueTasks(String user, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.getOverdueTasks", Task.class);
        query.setParameter("userName", (Object)user);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.cloneEntities(query.getResultList());
    }

    @Override
    public Long countOverdueTasks(String user) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.countOverdueTasks", Long.class);
        query.setParameter("userName", (Object)user);
        Long result = (Long)query.getSingleResult();
        return result == null ? 0L : result;
    }

    @Override
    public void addWatcherToTask(String username, Task task) throws Exception {
        Set<String> watchers = this.getWatchersOfTask(task);
        if (watchers != null && !watchers.contains(username)) {
            watchers.add(username);
            task.setWatcher(watchers);
            this.update(task);
        }
    }

    @Override
    public void deleteWatcherOfTask(String username, Task task) throws Exception {
        Set<String> watchers = this.getWatchersOfTask(task);
        if (watchers == null || !watchers.contains(username)) {
            throw new Exception("Cannot remove watcher " + username + "of task because watcher does not exist.");
        }
        watchers.remove(username);
        task.setWatcher(watchers);
        this.update(task);
    }

    @Override
    public Set<String> getWatchersOfTask(Task task) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.getWatcher", String.class);
        query.setParameter("taskid", (Object)task.getId());
        List watchers = query.getResultList();
        return new HashSet<String>(watchers);
    }

    @Override
    public List<Task> findTasks(String user, List<String> memberships, String term, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.findTasks", Task.class);
        query.setParameter("userName", (Object)user);
        query.setParameter("memberships", memberships);
        query.setParameter("term", (Object)("%" + term.replaceAll("%", "").toLowerCase() + "%"));
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.cloneEntities(query.getResultList());
    }

    @Override
    public long countTasks(String user, String term) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.countTasks", Long.class);
        query.setParameter("userName", (Object)user);
        query.setParameter("term", (Object)("%" + term.replaceAll("%", "").toLowerCase() + "%"));
        Long result = (Long)query.getSingleResult();
        return result == null ? 0L : result;
    }

    @Override
    public List<Object[]> countTaskStatusByProject(long projectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.countTaskStatusByProject", Object[].class).setParameter("projectId", (Object)projectId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<Object[]>();
        }
        catch (Exception e) {
            return new ArrayList<Object[]>();
        }
    }
}

