/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.service;

import io.meeds.social.category.plugin.CategoryPlugin;
import io.meeds.social.category.service.CategoryPluginService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryPluginServiceImpl
implements CategoryPluginService {
    @Autowired
    private List<CategoryPlugin> categoryPlugins;
    private Map<String, CategoryPlugin> categoryPluginsByType = new HashMap<String, CategoryPlugin>();

    public CategoryPlugin getCategoryPlugin(String objectType) {
        return this.categoryPluginsByType.computeIfAbsent(objectType, t -> this.categoryPlugins.stream().filter(c -> c.getType().equals(t)).findFirst().orElseThrow());
    }

    public boolean canEdit(String objectType, String objectId, String username) {
        return this.getCategoryPlugin(objectType).canEdit(objectId, username);
    }

    public List<Long> getCategoryIds(String objectType) {
        return this.getCategoryPlugin(objectType).getCategoryIds();
    }
}

