/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ChangesItem
implements Externalizable {
    private long workspaceChangedSize;
    private Map<String, Long> calculatedChangedNodesSize = new HashMap<String, Long>();
    private Set<String> unknownChangedNodesSize = new HashSet<String>();
    private Set<String> asyncUpdate = new HashSet<String>();

    public long getWorkspaceChangedSize() {
        return this.workspaceChangedSize;
    }

    public void updateWorkspaceChangedSize(long delta) {
        this.workspaceChangedSize += delta;
    }

    public long getNodeChangedSize(String nodePath) {
        Long delta = this.calculatedChangedNodesSize.get(nodePath);
        return delta == null ? 0L : delta;
    }

    public Map<String, Long> getAllNodesCalculatedChangedSize() {
        return this.calculatedChangedNodesSize;
    }

    public Set<String> getAllNodesUnknownChangedSize() {
        return this.unknownChangedNodesSize;
    }

    public void updateNodeChangedSize(String nodePath, long delta) {
        Long oldDelta = this.calculatedChangedNodesSize.get(nodePath);
        Long newDelta = delta + (oldDelta != null ? oldDelta : 0L);
        this.calculatedChangedNodesSize.put(nodePath, newDelta);
    }

    public void addPathWithUnknownChangedSize(String nodePath) {
        this.unknownChangedNodesSize.add(nodePath);
    }

    public void addPathWithAsyncUpdate(String nodePath) {
        this.asyncUpdate.add(nodePath);
    }

    public void merge(ChangesItem changesItem) {
        this.workspaceChangedSize += changesItem.getWorkspaceChangedSize();
        for (Map.Entry<String, Long> changesEntry : changesItem.calculatedChangedNodesSize.entrySet()) {
            String nodePath = changesEntry.getKey();
            Long currentDelta = changesEntry.getValue();
            Long oldDelta = this.calculatedChangedNodesSize.get(nodePath);
            Long newDelta = currentDelta + (oldDelta == null ? 0L : oldDelta);
            this.calculatedChangedNodesSize.put(nodePath, newDelta);
        }
        for (String path : changesItem.unknownChangedNodesSize) {
            this.unknownChangedNodesSize.add(path);
        }
        for (String path : changesItem.asyncUpdate) {
            this.asyncUpdate.add(path);
        }
    }

    public boolean isEmpty() {
        return this.workspaceChangedSize == 0L && this.calculatedChangedNodesSize.isEmpty() && this.unknownChangedNodesSize.isEmpty();
    }

    public ChangesItem extractSyncChanges() {
        ChangesItem syncChangesItem = new ChangesItem();
        Iterator<String> iter = this.calculatedChangedNodesSize.keySet().iterator();
        while (iter.hasNext() && !this.asyncUpdate.isEmpty()) {
            String nodePath = iter.next();
            if (this.asyncUpdate.contains(nodePath)) continue;
            Long chanagedSize = this.calculatedChangedNodesSize.get(nodePath);
            syncChangesItem.calculatedChangedNodesSize.put(nodePath, chanagedSize);
            syncChangesItem.workspaceChangedSize += chanagedSize.longValue();
            this.asyncUpdate.remove(nodePath);
            this.workspaceChangedSize -= chanagedSize.longValue();
            iter.remove();
        }
        return syncChangesItem;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.workspaceChangedSize);
        out.writeInt(this.calculatedChangedNodesSize.size());
        for (Map.Entry<String, Long> entry : this.calculatedChangedNodesSize.entrySet()) {
            this.writeString(out, entry.getKey());
            out.writeLong(entry.getValue());
        }
        out.writeInt(this.unknownChangedNodesSize.size());
        for (String path : this.unknownChangedNodesSize) {
            this.writeString(out, path);
        }
        out.writeInt(this.asyncUpdate.size());
        for (String path : this.asyncUpdate) {
            this.writeString(out, path);
        }
    }

    private void writeString(ObjectOutput out, String str) throws IOException {
        byte[] data = str.getBytes("UTF-8");
        out.writeInt(data.length);
        out.write(data);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String nodePath;
        int i;
        this.workspaceChangedSize = in.readLong();
        int size = in.readInt();
        this.calculatedChangedNodesSize = new HashMap<String, Long>(size);
        for (i = 0; i < size; ++i) {
            nodePath = this.readString(in);
            Long delta = in.readLong();
            this.calculatedChangedNodesSize.put(nodePath, delta);
        }
        size = in.readInt();
        this.unknownChangedNodesSize = new HashSet<String>(size);
        for (i = 0; i < size; ++i) {
            nodePath = this.readString(in);
            this.unknownChangedNodesSize.add(nodePath);
        }
        size = in.readInt();
        this.asyncUpdate = new HashSet<String>(size);
        for (i = 0; i < size; ++i) {
            nodePath = this.readString(in);
            this.asyncUpdate.add(nodePath);
        }
    }

    private String readString(ObjectInput in) throws IOException {
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        return new String(data, "UTF-8");
    }
}

