/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.transaction;

import java.util.LinkedList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.TransactionService;
import org.gatein.common.transaction.JTAUserTransactionLifecycleListener;
import org.gatein.common.transaction.JTAUserTransactionLifecycleService;

public class JTAUserTransactionLifecycleServiceImpl
implements JTAUserTransactionLifecycleService {
    private static final Log log = ExoLogger.getLogger(JTAUserTransactionLifecycleServiceImpl.class);
    private UserTransaction userTransaction;
    private TransactionService transactionService;
    private List<JTAUserTransactionLifecycleListener> listeners = new LinkedList<JTAUserTransactionLifecycleListener>();

    public JTAUserTransactionLifecycleServiceImpl(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public JTAUserTransactionLifecycleServiceImpl() {
    }

    @Override
    public void beginJTATransaction() {
        UserTransaction tx = this.getUserTransaction();
        try {
            if (tx == null) {
                log.debug((Object)"UserTransaction is null, ignore transactional behavior");
            } else if (tx.getStatus() == 6) {
                this.executeListenersBeforeBegin();
                tx.begin();
                this.executeListenersAfterBegin();
            } else {
                log.warn((Object)("UserTransaction not started as it's in state " + tx.getStatus()));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error when starting transaction", e);
        }
    }

    @Override
    public void finishJTATransaction() {
        UserTransaction tx = this.getUserTransaction();
        try {
            if (tx == null) {
                log.debug((Object)"UserTransaction is null, ignore transactional behavior");
            } else {
                int txStatus = tx.getStatus();
                if (txStatus == 6) {
                    log.warn((Object)"UserTransaction can't be finished as it wasn't started");
                } else if (txStatus == 1 || txStatus == 4 || txStatus == 9) {
                    log.warn((Object)("Going to rollback UserTransaction as it's status is " + txStatus));
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error when committing transaction", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserTransaction getUserTransaction() {
        if (this.userTransaction == null) {
            JTAUserTransactionLifecycleServiceImpl jTAUserTransactionLifecycleServiceImpl = this;
            synchronized (jTAUserTransactionLifecycleServiceImpl) {
                if (this.userTransaction == null) {
                    try {
                        this.userTransaction = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                    }
                    catch (NamingException ne) {
                        log.debug((Object)"UserTransaction not found via JNDI. Trying TransactionService");
                        this.userTransaction = this.transactionService.getUserTransaction();
                    }
                }
            }
        }
        return this.userTransaction;
    }

    @Override
    public void registerListener(JTAUserTransactionLifecycleListener listener) {
        log.info((Object)("Registered listener " + String.valueOf(listener)));
        this.listeners.add(listener);
    }

    protected void executeListenersBeforeBegin() {
        for (JTAUserTransactionLifecycleListener listener : this.listeners) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Execute listener " + String.valueOf(listener) + " before begin of JTA transaction"));
            }
            listener.beforeBegin();
        }
    }

    protected void executeListenersAfterBegin() {
        for (JTAUserTransactionLifecycleListener listener : this.listeners) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Execute listener " + String.valueOf(listener) + " after begin of JTA transaction"));
            }
            listener.afterBegin();
        }
    }
}

