/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.hash;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.hash.SaltedHash;
import org.exoplatform.web.security.hash.SaltedHashCodec;
import org.exoplatform.web.security.hash.SaltedHashException;
import org.exoplatform.web.security.hash.SaltedHashService;
import org.exoplatform.web.security.hash.XmlSafeSaltedHashCodec;
import org.exoplatform.web.security.security.SecureRandomService;

public class JCASaltedHashService
implements SaltedHashService {
    public static final String PBKDF2_WITH_HMAC_SHA1 = "PBKDF2WithHmacSHA1";
    public static final int DEFAULT_SALT_BYTE_LENGTH = 9;
    public static final int DEFAULT_HASH_BYTE_LENGTH = 9;
    public static final int DEFAULT_ITERATION_COUNT = 1000;
    private int iterationCount;
    private int saltByteLength;
    private int hashByteLength;
    private String algorithm;
    private SaltedHashCodec codec;
    private final Log log = ExoLogger.getLogger(JCASaltedHashService.class);

    public JCASaltedHashService(String algorithm, int iterationCount, int saltLength, int hashLength, SaltedHashCodec codec) {
        this.algorithm = algorithm;
        this.iterationCount = iterationCount;
        this.saltByteLength = saltLength;
        this.hashByteLength = hashLength;
        this.codec = codec;
    }

    public JCASaltedHashService() {
        this(PBKDF2_WITH_HMAC_SHA1, 1000, 9, 9, XmlSafeSaltedHashCodec.INSTANCE);
    }

    @Override
    public String getSaltedHash(String password) throws SaltedHashException {
        try {
            byte[] salt = new byte[this.saltByteLength];
            PortalContainer container = PortalContainer.getInstance();
            SecureRandom random = ((SecureRandomService)container.getComponentInstanceOfType(SecureRandomService.class)).getSecureRandom();
            random.nextBytes(salt);
            SaltedHash saltedHash = new SaltedHash(this.algorithm, this.iterationCount, salt, JCASaltedHashService.hash(this.algorithm, password, salt, this.iterationCount, this.hashByteLength));
            return this.codec.encode(saltedHash);
        }
        catch (InvalidKeySpecException e) {
            throw new SaltedHashException("Could not create salted hash from password.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaltedHashException("Could not create salted hash from password.", e);
        }
    }

    @Override
    public boolean validate(String password, String encodedSaltedHash) throws SaltedHashException {
        try {
            SaltedHash saltedHash = this.codec.decode(encodedSaltedHash);
            byte[] expectedHash = JCASaltedHashService.hash(saltedHash.getAlgorithm(), password, saltedHash.getSalt(), saltedHash.getIterationCount(), saltedHash.getHash().length);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("About to validate submitted hash " + Arrays.toString(expectedHash) + " against stored hash " + Arrays.toString(saltedHash.getHash())));
            }
            return Arrays.equals(expectedHash, saltedHash.getHash());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaltedHashException("Could not validate password against salted hash.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new SaltedHashException("Could not validate password against salted hash.", e);
        }
    }

    private static byte[] hash(String algorithm, String password, byte[] salt, int iterationCount, int hashLength) throws InvalidKeySpecException, NoSuchAlgorithmException {
        SecretKey key = SecretKeyFactory.getInstance(algorithm).generateSecret(new PBEKeySpec(password.toCharArray(), salt, iterationCount, hashLength * 8));
        return key.getEncoded();
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public int getSaltByteLength() {
        return this.saltByteLength;
    }

    public void setSaltLength(int saltLength) {
        this.saltByteLength = saltLength;
    }

    public int getHashByteLength() {
        return this.hashByteLength;
    }

    public void setHashLength(int hashLength) {
        this.hashByteLength = hashLength;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public SaltedHashCodec getCodec() {
        return this.codec;
    }

    public void setCodec(SaltedHashCodec codec) {
        this.codec = codec;
    }
}

