/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.listener;

import io.meeds.news.model.News;
import io.meeds.news.service.NewsService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.model.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalArticlePageListener
extends Listener<Object, Page> {
    private final ListenerService listenerService;
    private final NewsService newsService;
    private CachedActivityStorage cachedActivityStorage;
    private final MetadataService metadataService;
    private static final String NOTE_DELETED = "note.deleted";
    private static final String NOTE_UPDATED = "note.updated";
    private static final String ARTICLE = "article";
    private static final String NEWS_PAGE = "newsPage";
    private static final String[] LISTENER_EVENTS = new String[]{"note.deleted", "note.updated"};

    @Autowired
    public ExternalArticlePageListener(ListenerService listenerService, NewsService newsService, ActivityStorage activityStorage, MetadataService metadataService) {
        this.listenerService = listenerService;
        this.newsService = newsService;
        this.metadataService = metadataService;
        if (activityStorage instanceof CachedActivityStorage) {
            this.cachedActivityStorage = (CachedActivityStorage)activityStorage;
        }
    }

    @PostConstruct
    public void init() {
        for (String event : LISTENER_EVENTS) {
            this.listenerService.addListener(event, (ListenerBase)this);
        }
    }

    public void onEvent(Event<Object, Page> event) throws Exception {
        Page page = (Page)event.getData();
        if (page != null && !page.getOwner().equals("__system")) {
            if (event.getEventName().equals(NOTE_UPDATED)) {
                News news = this.newsService.getNewsArticleById(page.getId());
                if (news != null && news.getActivityId() != null) {
                    this.cachedActivityStorage.clearActivityCached(news.getActivityId());
                }
            } else {
                MetadataObject newsMetadataObject = new MetadataObject(NEWS_PAGE, page.getId());
                List articleProperties = this.metadataService.getMetadataItemsByObject(newsMetadataObject);
                if (event.getEventName().equals(NOTE_DELETED) && !articleProperties.isEmpty()) {
                    Identity identity = (Identity)event.getSource();
                    this.newsService.deleteNews(page.getId(), identity, ARTICLE);
                }
            }
        }
    }
}

