/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.impl.CommentServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.CommentServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.CommentServiceImpl$AjcClosure5;
import org.exoplatform.task.storage.CommentStorage;
import org.exoplatform.task.util.TaskUtil;

public class CommentServiceImpl
implements CommentService {
    private static final Log LOG;
    private CommentStorage commentStorage;
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public CommentServiceImpl(CommentStorage commentStorage, ListenerService listenerService) {
        this.commentStorage = commentStorage;
        this.listenerService = listenerService;
    }

    @Override
    public CommentDto getComment(long commentId) {
        return this.commentStorage.getComment(commentId);
    }

    @Override
    public List<CommentDto> getComments(long taskId, int offset, int limit) {
        return this.commentStorage.getComments(taskId, offset, limit);
    }

    @Override
    public List<CommentDto> getCommentsWithSubs(long taskId, int offset, int limit) {
        return this.commentStorage.getCommentsWithSubs(taskId, offset, limit);
    }

    @Override
    public int countComments(long taskId) {
        return this.commentStorage.countComments(taskId);
    }

    @Override
    public List<CommentDto> loadSubComments(List<CommentDto> listComments) {
        if (listComments == null || listComments.isEmpty()) {
            return null;
        }
        listComments.forEach(comment -> comment.setComment(MentionUtils.substituteUsernames((String)comment.getComment())));
        List<CommentDto> subComments = this.commentStorage.loadSubComments(listComments);
        for (CommentDto comment2 : listComments) {
            subComments.forEach(subComment -> subComment.setComment(MentionUtils.substituteUsernames((String)subComment.getComment())));
            comment2.setSubComments(subComments.stream().filter(subComment -> subComment.getParentComment().getId() == comment2.getId()).toList());
        }
        return listComments;
    }

    @Override
    @ExoTransactional
    public CommentDto addComment(TaskDto task, long parentCommentId, String username, String comment) throws EntityNotFoundException {
        TaskDto taskDto = task;
        long l = parentCommentId;
        String string = username;
        String string2 = comment;
        Object[] objectArray = new Object[]{taskDto, Conversions.longObject((long)l), string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, taskDto, Conversions.longObject((long)l), string, string2, joinPoint};
        CommentServiceImpl$AjcClosure1 commentServiceImpl$AjcClosure1 = new CommentServiceImpl$AjcClosure1(objectArray2);
        return (CommentDto)ExoTransactionalAspect.aspectOf().around(commentServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public CommentDto addComment(TaskDto task, String username, String comment) throws EntityNotFoundException {
        TaskDto taskDto = task;
        String string = username;
        String string2 = comment;
        Object[] objectArray = new Object[]{taskDto, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, taskDto, string, string2, joinPoint};
        CommentServiceImpl$AjcClosure3 commentServiceImpl$AjcClosure3 = new CommentServiceImpl$AjcClosure3(objectArray2);
        return (CommentDto)ExoTransactionalAspect.aspectOf().around(commentServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeComment(long commentId) throws EntityNotFoundException {
        long l = commentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        CommentServiceImpl$AjcClosure5 commentServiceImpl$AjcClosure5 = new CommentServiceImpl$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(commentServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    static {
        CommentServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(CommentServiceImpl.class);
    }

    static final /* synthetic */ CommentDto addComment_aroundBody0(CommentServiceImpl ajc$this, TaskDto task, long parentCommentId, String username, String comment, JoinPoint joinPoint) {
        CommentDto commentDto = ajc$this.commentStorage.addComment(task, parentCommentId, username, comment);
        if (commentDto != null) {
            TaskUtil.broadcastEvent(ajc$this.listenerService, "exo.task.taskCommentCreation", commentDto.getTask(), commentDto);
            if (commentDto.getTask().getStatus() != null && commentDto.getTask().getStatus().getProject() != null) {
                TaskUtil.broadcastEvent(ajc$this.listenerService, "exo.project.projectModified", null, commentDto.getTask().getStatus().getProject());
            }
        }
        return commentDto;
    }

    static final /* synthetic */ CommentDto addComment_aroundBody2(CommentServiceImpl ajc$this, TaskDto task, String username, String comment, JoinPoint joinPoint) {
        return ajc$this.addComment(task, 0L, username, comment);
    }

    static final /* synthetic */ void removeComment_aroundBody4(CommentServiceImpl ajc$this, long commentId, JoinPoint joinPoint) {
        CommentDto comment = ajc$this.commentStorage.getComment(commentId);
        if (comment == null) {
            LOG.info((Object)("Can not find comment with ID: " + commentId));
            throw new EntityNotFoundException(commentId, (Class<?>)CommentDto.class);
        }
        ajc$this.commentStorage.removeComment(commentId);
        TaskUtil.broadcastEvent(ajc$this.listenerService, "exo.task.taskCommentDeletion", comment.getTask(), comment);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CommentServiceImpl.java", CommentServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addComment", "org.exoplatform.task.service.impl.CommentServiceImpl", "org.exoplatform.task.dto.TaskDto:long:java.lang.String:java.lang.String", "task:parentCommentId:username:comment", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.CommentDto"), 90);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addComment", "org.exoplatform.task.service.impl.CommentServiceImpl", "org.exoplatform.task.dto.TaskDto:java.lang.String:java.lang.String", "task:username:comment", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.CommentDto"), 103);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeComment", "org.exoplatform.task.service.impl.CommentServiceImpl", "long", "commentId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 110);
    }
}

