/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.RepositorySettingsBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ReadOnlyUrlRepositorySettings
extends RepositorySettingsBase {
    @Nullable
    private final Integer httpMaxRetries;
    @Nullable
    private final Time httpSocketTimeout;
    @Nullable
    private final Integer maxNumberOfSnapshots;
    private final String url;
    public static final JsonpDeserializer<ReadOnlyUrlRepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReadOnlyUrlRepositorySettings::setupReadOnlyUrlRepositorySettingsDeserializer);

    private ReadOnlyUrlRepositorySettings(Builder builder) {
        super(builder);
        this.httpMaxRetries = builder.httpMaxRetries;
        this.httpSocketTimeout = builder.httpSocketTimeout;
        this.maxNumberOfSnapshots = builder.maxNumberOfSnapshots;
        this.url = ApiTypeHelper.requireNonNull(builder.url, this, "url");
    }

    public static ReadOnlyUrlRepositorySettings of(Function<Builder, ObjectBuilder<ReadOnlyUrlRepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer httpMaxRetries() {
        return this.httpMaxRetries;
    }

    @Nullable
    public final Time httpSocketTimeout() {
        return this.httpSocketTimeout;
    }

    @Nullable
    public final Integer maxNumberOfSnapshots() {
        return this.maxNumberOfSnapshots;
    }

    public final String url() {
        return this.url;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.httpMaxRetries != null) {
            generator.writeKey("http_max_retries");
            generator.write(this.httpMaxRetries.intValue());
        }
        if (this.httpSocketTimeout != null) {
            generator.writeKey("http_socket_timeout");
            this.httpSocketTimeout.serialize(generator, mapper);
        }
        if (this.maxNumberOfSnapshots != null) {
            generator.writeKey("max_number_of_snapshots");
            generator.write(this.maxNumberOfSnapshots.intValue());
        }
        generator.writeKey("url");
        generator.write(this.url);
    }

    protected static void setupReadOnlyUrlRepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        RepositorySettingsBase.setupRepositorySettingsBaseDeserializer(op);
        op.add(Builder::httpMaxRetries, JsonpDeserializer.integerDeserializer(), "http_max_retries");
        op.add(Builder::httpSocketTimeout, Time._DESERIALIZER, "http_socket_timeout");
        op.add(Builder::maxNumberOfSnapshots, JsonpDeserializer.integerDeserializer(), "max_number_of_snapshots");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
    }

    public static class Builder
    extends RepositorySettingsBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ReadOnlyUrlRepositorySettings> {
        @Nullable
        private Integer httpMaxRetries;
        @Nullable
        private Time httpSocketTimeout;
        @Nullable
        private Integer maxNumberOfSnapshots;
        private String url;

        public final Builder httpMaxRetries(@Nullable Integer value) {
            this.httpMaxRetries = value;
            return this;
        }

        public final Builder httpSocketTimeout(@Nullable Time value) {
            this.httpSocketTimeout = value;
            return this;
        }

        public final Builder httpSocketTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.httpSocketTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxNumberOfSnapshots(@Nullable Integer value) {
            this.maxNumberOfSnapshots = value;
            return this;
        }

        public final Builder url(String value) {
            this.url = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReadOnlyUrlRepositorySettings build() {
            this._checkSingleUse();
            return new ReadOnlyUrlRepositorySettings(this);
        }
    }
}

