/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;

public class GamificationProfileListener
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GamificationProfileListener.class);
    private ListenerService listenerService;

    public GamificationProfileListener(ListenerService listenerService) {
        this.listenerService = listenerService;
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        this.createRealizations("addUserProfileAvatar", event.getProfile(), event.getModifierUsername());
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        this.createRealizations("addUserProfileBanner", event.getProfile(), event.getModifierUsername());
    }

    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
        this.createRealizations("addUserProfileAboutMe", event.getProfile(), event.getModifierUsername());
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        this.createRealizations("addUserProfileContactInformation", event.getProfile(), event.getModifierUsername());
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        this.createRealizations("addUserProfileWorkExperience", event.getProfile(), event.getModifierUsername());
    }

    private void createRealizations(String gamificationEventName, Profile profile, String modifierUsername) {
        if (profile == null || StringUtils.isBlank((CharSequence)modifierUsername) || !StringUtils.equals((CharSequence)profile.getIdentity().getRemoteId(), (CharSequence)modifierUsername)) {
            return;
        }
        String identityId = profile.getIdentity().getId();
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", identityId);
            gam.put("objectType", "identity");
            gam.put("senderId", identityId);
            gam.put("receiverId", identityId);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }
}

