/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.storage.cache;

import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.storage.CMSStorage;
import io.meeds.social.cms.storage.model.CMSSettingKey;
import java.io.Serializable;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.social.metadata.MetadataService;

public class CachedCMSStorage
extends CMSStorage {
    public static final String CACHE_NAME = "social.cmsSetting";
    private ExoCache<CMSSettingKey, CMSSetting> cache;
    private FutureExoCache<CMSSettingKey, CMSSetting, Object> futureCache;

    public CachedCMSStorage(CacheService cacheService, MetadataService metadataService) {
        super(metadataService);
        this.cache = cacheService.getCacheInstance(CACHE_NAME);
        Loader<CMSSettingKey, CMSSetting, Object> loader = new Loader<CMSSettingKey, CMSSetting, Object>(){

            public CMSSetting retrieve(Object context, CMSSettingKey key) throws Exception {
                return CachedCMSStorage.super.getSetting(key.getType(), key.getName());
            }
        };
        this.futureCache = new FutureExoCache((Loader)loader, this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSetting(String type, String name, String pageReference, long spaceId, long userCreatorId) throws ObjectAlreadyExistsException {
        try {
            super.saveSetting(type, name, pageReference, spaceId, userCreatorId);
        }
        finally {
            this.clearSetting(type, name);
        }
    }

    @Override
    public CMSSetting getSetting(String type, String name) {
        return this.clone((CMSSetting)this.futureCache.get(null, (Object)new CMSSettingKey(type, name)));
    }

    private void clearSetting(String type, String name) {
        this.futureCache.remove((Serializable)new CMSSettingKey(type, name));
    }

    private CMSSetting clone(CMSSetting cmsSetting) {
        return cmsSetting == null ? null : cmsSetting.clone();
    }
}

