/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import io.meeds.news.model.News;
import io.meeds.news.model.NewsPageObject;
import io.meeds.news.service.NewsService;
import io.meeds.notes.model.NotePageProperties;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.upgrade.jcr.NewsArticlesUpgrade$AjcClosure1;
import org.exoplatform.services.attachments.storage.AttachmentStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.service.NoteService;

public class NewsArticlesUpgrade
extends UpgradeProductPlugin {
    private static final Log LOG;
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private NewsService newsService;
    private SpaceService spaceService;
    private ActivityManager activityManager;
    private MetadataService metadataService;
    private FileService fileService;
    private NoteService noteService;
    private IndexingService indexingService;
    private IdentityManager identityManager;
    private SettingService settingService;
    private AttachmentStorage attachmentStorage;
    private EntityManagerService entityManagerService;
    private int migratedNewsArticlesCount = 0;
    public static final MetadataType NEWS_METADATA_TYPE;
    public static final String NEWS_METADATA_NAME = "news";
    private static final MetadataKey NEWS_METADATA_KEY;
    private static final MetadataKey NOTES_METADATA_KEY;
    private static final String PLUGIN_NAME = "NewsArticlesUpgradePlugin";
    private static final String PLUGIN_EXECUTED_KEY = "articlesUpgradeExecuted";
    private boolean upgradeFailed = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public NewsArticlesUpgrade(InitParams initParams, RepositoryService repositoryService, SessionProviderService sessionProviderService, NewsService newsService, SpaceService spaceService, ActivityManager activityManager, MetadataService metadataService, FileService fileService, NoteService noteService, IdentityManager identityManager, IndexingService indexingService, AttachmentStorage attachmentStorage, SettingService settingService, EntityManagerService entityManagerService) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.newsService = newsService;
        this.spaceService = spaceService;
        this.activityManager = activityManager;
        this.metadataService = metadataService;
        this.fileService = fileService;
        this.noteService = noteService;
        this.identityManager = identityManager;
        this.indexingService = indexingService;
        this.settingService = settingService;
        this.attachmentStorage = attachmentStorage;
        this.entityManagerService = entityManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start upgrade of news articles");
        SessionProvider sessionProvider = null;
        int notMigratedNewsArticlesCount = 0;
        int processedNewsArticlesCount = 0;
        long totalNewsArticlesCount = 0L;
        try {
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            NodeTypeManagerImpl ntManager = (NodeTypeManagerImpl)session.getWorkspace().getNodeTypeManager();
            if (ntManager.hasNodeType("exo:news")) {
                String queryString = "SELECT * FROM exo:news WHERE jcr:path LIKE '/Groups/spaces/%/News/%' order by exo:dateModified DESC";
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                javax.jcr.query.Query query = queryManager.createQuery(queryString, "sql");
                NodeIterator newsIterator = query.execute().getNodes();
                ArrayList<String> newsArticlesNodesUUIDs = new ArrayList<String>();
                while (newsIterator.hasNext()) {
                    Node newsArticleNode = (Node)newsIterator.next();
                    if (!this.newsNodeIgnored(newsArticleNode)) {
                        newsArticlesNodesUUIDs.add(newsArticleNode.getUUID());
                        continue;
                    }
                    newsArticleNode.remove();
                    session.save();
                }
                totalNewsArticlesCount = newsArticlesNodesUUIDs.size();
                LOG.info("Total number of news articles to be migrated: {}", new Object[]{totalNewsArticlesCount});
                for (List newsArticlesChunk : ListUtils.partition(newsArticlesNodesUUIDs, (int)10)) {
                    int notMigratedNewsArticlesCountByTransaction = this.manageNewsArticles(newsArticlesChunk, sessionProvider);
                    int processedNewsArticlesCountByTransaction = newsArticlesChunk.size();
                    this.migratedNewsArticlesCount += processedNewsArticlesCountByTransaction - notMigratedNewsArticlesCountByTransaction;
                    LOG.info("News articles migration progress: processed={}/{} succeeded={} error={}", new Object[]{processedNewsArticlesCount += processedNewsArticlesCountByTransaction, totalNewsArticlesCount, this.migratedNewsArticlesCount, notMigratedNewsArticlesCount += notMigratedNewsArticlesCountByTransaction});
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred when upgrading news articles:", (Throwable)e);
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
        if (totalNewsArticlesCount != (long)this.migratedNewsArticlesCount) {
            LOG.warn("End news articles migration with some errors: total={} succeeded={} error={}. It tooks {} ms. The not migrated news articles will be processed again next startup.", new Object[]{totalNewsArticlesCount, this.migratedNewsArticlesCount, notMigratedNewsArticlesCount, System.currentTimeMillis() - startupTime});
            this.upgradeFailed = true;
            throw new IllegalStateException("Some news articles wasn't executed successfully. It will be re-attempted next startup");
        }
        LOG.info("End news articles migration successful migration: total={} succeeded={} error={}. It tooks {} ms.", new Object[]{totalNewsArticlesCount, this.migratedNewsArticlesCount, notMigratedNewsArticlesCount, System.currentTimeMillis() - startupTime});
    }

    public void afterUpgrade() {
        if (!this.upgradeFailed) {
            this.settingService.set(Context.GLOBAL.id(PLUGIN_NAME), Scope.APPLICATION.id(PLUGIN_NAME), PLUGIN_EXECUTED_KEY, SettingValue.create((Boolean)true));
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext upgradePluginExecutionContext) {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL.id(PLUGIN_NAME), Scope.APPLICATION.id(PLUGIN_NAME), PLUGIN_EXECUTED_KEY);
        boolean shouldUpgrade = super.shouldProceedToUpgrade(newVersion, previousGroupVersion, upgradePluginExecutionContext);
        if (!shouldUpgrade && settingValue == null) {
            this.settingService.set(Context.GLOBAL.id(PLUGIN_NAME), Scope.APPLICATION.id(PLUGIN_NAME), PLUGIN_EXECUTED_KEY, SettingValue.create((Boolean)true));
        }
        return shouldUpgrade;
    }

    public int manageNewsArticles(List<String> newsArticlesNodesUUIDs, SessionProvider sessionProvider) {
        int notMigratedNewsArticlesCountByTransaction = 0;
        for (String newsArticleNodeUUID : newsArticlesNodesUUIDs) {
            News article = null;
            News draftArticle = null;
            try {
                Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
                Node newsArticleNode = session.getNodeByUUID(newsArticleNodeUUID);
                this.indexingService.unindex(NEWS_METADATA_NAME, newsArticleNodeUUID);
                News news = this.convertNewsNodeToNewsEntity(newsArticleNode, null);
                NotePageProperties properties = news.getProperties();
                LOG.info("Migrating news article with id '{}' and title '{}'", new Object[]{newsArticleNodeUUID, news.getTitle()});
                Space space = this.spaceService.getSpaceById(news.getSpaceId());
                if (this.getStringProperty(newsArticleNode, "publication:currentState").equals("staged") || this.getStringProperty(newsArticleNode, "publication:currentState").equals("published")) {
                    article = this.newsService.createNewsArticlePage(news, news.getAuthor());
                    properties.setNoteId(Long.parseLong(article.getId()));
                    if (news.getAuthor() != null) {
                        this.noteService.saveNoteMetadata(properties, article.getLang(), Long.valueOf(this.identityManager.getOrCreateUserIdentity(news.getAuthor()).getId()));
                    }
                    PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(article.getId())), null);
                    session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
                    newsArticleNode = session.getNodeByUUID(newsArticleNodeUUID);
                    this.setArticleIllustration(pageVersion.getParent(), article.getSpaceId(), newsArticleNode, "notePage");
                    this.setArticleAttachments(pageVersion.getId(), newsArticleNode);
                    if (this.getStringProperty(newsArticleNode, "publication:currentState").equals("published")) {
                        this.setArticleActivities(article, newsArticleNode);
                        this.setArticleViews(article, newsArticleNode);
                        this.indexingService.index(NEWS_METADATA_NAME, article.getId());
                    }
                    if (this.getStringProperty(newsArticleNode, "publication:currentState").equals("staged")) {
                        this.setSchedulePostDate(article.getId(), article.getSpaceId(), newsArticleNode, "newsPage");
                    }
                    this.setArticleCreateAndUpdateDate(article.getId(), article.getSpaceId(), newsArticleNode);
                    this.setArticleMetadatasItems(article.getId(), newsArticleNodeUUID);
                } else if (this.getStringProperty(newsArticleNode, "publication:currentState").equals("draft")) {
                    if (!newsArticleNode.hasProperty("publication:liveRevision")) {
                        properties.setDraft(true);
                        news.setProperties(properties);
                        draftArticle = this.newsService.createDraftArticleForNewPage(news, space.getGroupId(), news.getAuthor(), news.getCreationDate().getTime());
                        DraftPage draftPage = this.noteService.getDraftNoteById(draftArticle.getId(), draftArticle.getAuthor());
                        properties.setNoteId(Long.parseLong(draftPage.getId()));
                        if (news.getAuthor() != null) {
                            this.noteService.saveNoteMetadata(properties, draftPage.getLang(), Long.valueOf(this.identityManager.getOrCreateUserIdentity(news.getAuthor()).getId()));
                        }
                        session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
                        newsArticleNode = session.getNodeByUUID(newsArticleNodeUUID);
                        this.setArticleIllustration((Page)draftPage, draftArticle.getSpaceId(), newsArticleNode, "noteDraftPage");
                    } else {
                        String versionNodeUUID = newsArticleNode.getProperty("publication:liveRevision").getString();
                        Node versionNode = newsArticleNode.getVersionHistory().getSession().getNodeByUUID(versionNodeUUID);
                        Node publishedNode = versionNode.getNode("jcr:frozenNode");
                        News publishedNews = this.convertNewsNodeToNewsEntity(newsArticleNode, publishedNode);
                        article = this.newsService.createNewsArticlePage(publishedNews, publishedNews.getAuthor());
                        properties = publishedNews.getProperties();
                        properties.setNoteId(Long.parseLong(article.getId()));
                        if (publishedNews.getAuthor() != null) {
                            properties = this.noteService.saveNoteMetadata(properties, article.getLang(), Long.valueOf(this.identityManager.getOrCreateUserIdentity(publishedNews.getAuthor()).getId()));
                        }
                        PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(article.getId())), null);
                        session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
                        newsArticleNode = session.getNodeByUUID(newsArticleNodeUUID);
                        this.setArticleIllustration(pageVersion.getParent(), article.getSpaceId(), publishedNode, "notePage");
                        this.setArticleAttachments(pageVersion.getId(), publishedNode);
                        this.setArticleActivities(article, publishedNode);
                        this.setArticleViews(article, newsArticleNode);
                        this.setArticleCreateAndUpdateDate(article.getId(), article.getSpaceId(), newsArticleNode);
                        if (this.spaceService.canRedactOnSpace(space, news.getDraftUpdaterUserName())) {
                            Page publishedPage = this.noteService.getNoteById(article.getId());
                            properties.setDraft(true);
                            news.setProperties(properties);
                            News draftForExistingArticle = this.newsService.createDraftForExistingPage(news, news.getDraftUpdaterUserName(), publishedPage, news.getCreationDate().getTime(), space);
                            DraftPage draftPage = this.noteService.getDraftNoteById(draftForExistingArticle.getId(), news.getDraftUpdaterUserName());
                            session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
                            newsArticleNode = session.getNodeByUUID(newsArticleNodeUUID);
                            this.setArticleIllustration((Page)draftPage, draftForExistingArticle.getSpaceId(), newsArticleNode, "noteDraftPage");
                        }
                        this.setArticleMetadatasItems(article.getId(), newsArticleNodeUUID);
                    }
                }
                if (!session.isLive()) {
                    session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
                    newsArticleNode = session.getNodeByUUID(newsArticleNodeUUID);
                }
                newsArticleNode.remove();
                session.save();
                LOG.info("Success migrating news article with id '{}' and title '{}'", new Object[]{newsArticleNodeUUID, news.getTitle()});
            }
            catch (Exception e) {
                ++notMigratedNewsArticlesCountByTransaction;
                LOG.warn("Error migrating news article with id '{}'. Continue to migrate other items", new Object[]{newsArticleNodeUUID, e});
                try {
                    if (article != null) {
                        this.newsService.deleteArticle(article, article.getAuthor());
                        this.setArticleMetadatasItems(newsArticleNodeUUID, article.getId());
                        continue;
                    }
                    if (draftArticle == null) continue;
                    this.newsService.deleteDraftArticle(draftArticle.getId(), draftArticle.getAuthor());
                }
                catch (Exception exception) {
                    if (article != null) {
                        LOG.warn("The deletion of the not migrated news article with id '{}' is not well completed, to be verified and deleted manually.", new Object[]{article.getId()});
                        continue;
                    }
                    if (draftArticle == null) continue;
                    LOG.warn("The deletion of the not migrated news draft article with id '{}' is not well completed, to be verified and deleted manually.", new Object[]{draftArticle.getId()});
                }
            }
        }
        return notMigratedNewsArticlesCountByTransaction;
    }

    private News convertNewsNodeToNewsEntity(Node newsNode, Node newsVersionNode) throws Exception {
        News news = new News();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        news.setTitle(this.getStringProperty(newsVersionNode != null ? newsVersionNode : newsNode, "exo:title"));
        news.setName(news.getTitle() + "_" + newsNode.getUUID());
        NotePageProperties properties = new NotePageProperties();
        properties.setSummary(this.getStringProperty(newsVersionNode != null ? newsVersionNode : newsNode, "exo:summary"));
        news.setProperties(properties);
        String body = this.getStringProperty(newsVersionNode != null ? newsVersionNode : newsNode, "exo:body");
        String sanitizedBody = HTMLSanitizer.sanitize((String)body);
        sanitizedBody = sanitizedBody.replaceAll("&#64;", "@");
        news.setBody(MentionUtils.substituteUsernames((String)portalOwner, (String)sanitizedBody));
        news.setAuthor(this.getStringProperty(newsNode, "exo:author"));
        if (newsVersionNode == null) {
            news.setDraftUpdaterUserName(this.getStringProperty(newsNode, "exo:newsLastModifier"));
        }
        news.setSpaceId(this.getStringProperty(newsNode, "exo:spaceId"));
        news.setAudience(this.getStringProperty(newsNode, "exo:audience"));
        news.setPublicationState(this.getStringProperty(newsNode, "publication:currentState").equals("published") || newsVersionNode != null ? "posted" : this.getStringProperty(newsNode, "publication:currentState"));
        news.setPublished(this.getBooleanProperty(newsNode, "exo:pinned"));
        news.setActivityPosted(!this.getBooleanProperty(newsVersionNode != null ? newsVersionNode : newsNode, "exo:newsActivityPosted"));
        news.setUploadId("");
        news.setCreationDate(this.getDateProperty(newsNode, "exo:dateCreated"));
        news.setUpdateDate(this.getDateProperty(newsNode, "exo:dateModified"));
        return news;
    }

    private boolean getBooleanProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getBoolean();
        }
        return false;
    }

    private String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return "";
    }

    private Long getLongProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getLong();
        }
        return null;
    }

    private Date getDateProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDate().getTime();
        }
        return null;
    }

    private Long saveArticleIllustration(InputStream articleIllustrationFileInputStream, String fileName, String mimeType, long uploadSize) {
        try {
            FileItem articleIllustrationFileItem = new FileItem(null, fileName, mimeType, "wiki", uploadSize, new Date(), IdentityConstants.SYSTEM, false, articleIllustrationFileInputStream);
            articleIllustrationFileItem = this.fileService.writeFile(articleIllustrationFileItem);
            return articleIllustrationFileItem != null && articleIllustrationFileItem.getFileInfo() != null ? articleIllustrationFileItem.getFileInfo().getId() : null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while saving article illustration file", e);
        }
    }

    private void setArticleIllustration(Page article, String spaceId, Node newsNode, String articleObjectType) throws Exception {
        if (newsNode.hasNode("illustration")) {
            Node illustrationNode = newsNode.getNode("illustration");
            Node illustrationContentNode = illustrationNode.getNode("jcr:content");
            InputStream illustrationNodeInputStream = illustrationContentNode.getProperty("jcr:data").getStream();
            String mimetype = illustrationContentNode.getProperty("jcr:mimeType").getString();
            String illustrationNodeName = illustrationNode.getProperty("exo:title").getString();
            Long articleIllustrationId = this.saveArticleIllustration(illustrationNodeInputStream, illustrationNodeName, mimetype, 0L);
            if (article != null && article.getAuthor() != null) {
                long creatorId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(article.getAuthor()).getId());
                MetadataObject articleMetaDataObject = new MetadataObject(articleObjectType, article.getId(), article.getParentPageId(), Long.parseLong(spaceId));
                MetadataItem articleMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NOTES_METADATA_KEY, articleMetaDataObject).stream().findFirst().orElse(null);
                Map<String, String> articleMetadataItemProperties = new HashMap<String, String>();
                if (articleMetadataItem != null && !MapUtils.isEmpty((Map)articleMetadataItem.getProperties())) {
                    articleMetadataItemProperties = articleMetadataItem.getProperties();
                }
                articleMetadataItemProperties.put("featuredImageId", String.valueOf(articleIllustrationId));
                articleMetadataItemProperties.put("featuredImageUpdatedDate", String.valueOf(new Date().getTime()));
                if (articleMetadataItem != null) {
                    articleMetadataItem.setProperties(articleMetadataItemProperties);
                    this.metadataService.updateMetadataItem(articleMetadataItem, creatorId, false);
                } else {
                    this.metadataService.createMetadataItem(articleMetaDataObject, NOTES_METADATA_KEY, articleMetadataItemProperties, creatorId, false);
                }
            }
        }
    }

    private void setArticleActivities(News article, Node newsNode) throws RepositoryException {
        NewsPageObject articleMetaDataObject = new NewsPageObject("newsPage", article.getId(), null, Long.parseLong(article.getSpaceId()));
        MetadataItem articleMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)articleMetaDataObject).stream().findFirst().orElse(null);
        String articleActivities = this.getStringProperty(newsNode, "exo:activities");
        if (!articleActivities.equals("") && articleMetadataItem != null) {
            String newsActivityId;
            ExoSocialActivity activity;
            HashMap<String, String> articleMetadataItemProperties = articleMetadataItem.getProperties();
            if (articleMetadataItemProperties == null) {
                articleMetadataItemProperties = new HashMap<String, String>();
            }
            articleMetadataItemProperties.put("activities", articleActivities);
            articleMetadataItem.setProperties(articleMetadataItemProperties);
            this.metadataService.updateMetadataItem(articleMetadataItem, articleMetadataItem.getCreatorId(), false);
            String newsActivity = articleActivities.split(";")[0];
            if (newsActivity.split(":").length > 1 && (activity = this.activityManager.getActivity(newsActivityId = newsActivity.split(":")[1])) != null) {
                Map<String, String> templateParams = activity.getTemplateParams() == null ? new HashMap() : activity.getTemplateParams();
                templateParams.put("newsId", article.getId());
                activity.setTemplateParams(templateParams);
                activity.setMetadataObjectId(article.getId());
                activity.setMetadataObjectType(NEWS_METADATA_NAME);
                this.activityManager.updateActivity(activity, false);
            }
        }
    }

    private void setArticleViews(News article, Node newsNode) throws RepositoryException {
        NewsPageObject articleMetaDataObject = new NewsPageObject("newsPage", article.getId(), null, Long.parseLong(article.getSpaceId()));
        MetadataItem articleMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)articleMetaDataObject).stream().findFirst().orElse(null);
        Long articleViewsCount = this.getLongProperty(newsNode, "exo:viewsCount");
        String articleViewers = this.getStringProperty(newsNode, "exo:viewers");
        if (articleMetadataItem != null) {
            HashMap<String, String> articleMetadataItemProperties = articleMetadataItem.getProperties();
            if (articleMetadataItemProperties == null) {
                articleMetadataItemProperties = new HashMap<String, String>();
            }
            articleMetadataItemProperties.put("viewsCount", String.valueOf(articleViewsCount));
            articleMetadataItemProperties.put("viewers", articleViewers);
            articleMetadataItem.setProperties(articleMetadataItemProperties);
            this.metadataService.updateMetadataItem(articleMetadataItem, articleMetadataItem.getCreatorId(), false);
        }
    }

    private void setArticleAttachments(String articleId, Node newsNode) throws RepositoryException {
        if (newsNode.hasProperty("exo:attachmentsIds")) {
            Property attachmentsIdsProperty = newsNode.getProperty("exo:attachmentsIds");
            for (Value value : attachmentsIdsProperty.getValues()) {
                String attachmentId = value.getString();
                if (!StringUtils.isNotEmpty((CharSequence)attachmentId) || !StringUtils.isNotEmpty((CharSequence)articleId)) continue;
                this.attachmentStorage.linkAttachmentToEntity(Long.valueOf(articleId).longValue(), "WIKI_PAGE_VERSIONS", attachmentId);
            }
        }
    }

    private void setSchedulePostDate(String articleId, String spaceId, Node newsNode, String articleObjectType) throws RepositoryException {
        if (newsNode.hasProperty("publication:startPublishedDate")) {
            Calendar startPostDate = newsNode.getProperty("publication:startPublishedDate").getDate();
            SimpleDateFormat defaultFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            defaultFormat.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
            String scheduledPostDate = defaultFormat.format(startPostDate.getTime());
            MetadataObject articleMetaDataObject = new MetadataObject(articleObjectType, articleId, null, Long.parseLong(spaceId));
            MetadataItem articleMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, articleMetaDataObject).stream().findFirst().orElse(null);
            if (articleMetadataItem != null) {
                HashMap<String, String> articleMetadataItemProperties = articleMetadataItem.getProperties();
                if (articleMetadataItemProperties == null) {
                    articleMetadataItemProperties = new HashMap<String, String>();
                }
                articleMetadataItemProperties.put("schedulePostDate", scheduledPostDate);
                articleMetadataItem.setProperties(articleMetadataItemProperties);
                this.metadataService.updateMetadataItem(articleMetadataItem, articleMetadataItem.getCreatorId(), false);
            }
        }
    }

    @ExoTransactional
    private void setArticleMetadatasItems(String targetId, String sourceId) throws RepositoryException {
        String string = targetId;
        String string2 = sourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        NewsArticlesUpgrade$AjcClosure1 newsArticlesUpgrade$AjcClosure1 = new NewsArticlesUpgrade$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(newsArticlesUpgrade$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void setArticleCreateAndUpdateDate(String articleId, String spaceId, Node newsNode) throws Exception {
        Page articlePage = this.noteService.getNoteById(articleId);
        if (articlePage != null) {
            Date createdDate = this.getDateProperty(newsNode, "exo:dateCreated");
            Date updatedDate = this.getDateProperty(newsNode, "exo:dateModified");
            MetadataItem articleMetaDataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)new NewsPageObject("newsPage", articleId, null, Long.parseLong(spaceId))).stream().findFirst().orElse(null);
            if (updatedDate != null) {
                articlePage.setUpdatedDate(updatedDate);
                articleMetaDataItem.setUpdatedDate(updatedDate.getTime());
            }
            if (createdDate != null) {
                articlePage.setCreatedDate(createdDate);
                articleMetaDataItem.setCreatedDate(createdDate.getTime());
            }
            this.noteService.updateNote(articlePage);
            this.metadataService.updateMetadataItem(articleMetaDataItem, articleMetaDataItem.getCreatorId(), false);
        }
    }

    private boolean newsNodeIgnored(Node newsNode) throws Exception {
        if (this.getBooleanProperty(newsNode, "exo:archived")) {
            return true;
        }
        if (this.getStringProperty(newsNode, "publication:currentState").equals("draft") && !newsNode.hasProperty("publication:liveRevision")) {
            String author = this.getStringProperty(newsNode, "exo:author");
            String spaceId = this.getStringProperty(newsNode, "exo:spaceId");
            return !this.spaceService.canRedactOnSpace(this.spaceService.getSpaceById(spaceId), author);
        }
        return false;
    }

    static {
        NewsArticlesUpgrade.ajc$preClinit();
        LOG = ExoLogger.getLogger((String)NewsArticlesUpgrade.class.getName());
        NEWS_METADATA_TYPE = new MetadataType(1000L, NEWS_METADATA_NAME);
        NEWS_METADATA_KEY = new MetadataKey(NEWS_METADATA_TYPE.getName(), NEWS_METADATA_NAME, 0L);
        NOTES_METADATA_KEY = new MetadataKey("notes", "notes", 0L);
    }

    static final /* synthetic */ void setArticleMetadatasItems_aroundBody0(NewsArticlesUpgrade ajc$this, String targetId, String sourceId, JoinPoint joinPoint) {
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        String sqlStatement = "UPDATE SOC_METADATA_ITEMS SET OBJECT_ID = '" + targetId + "' WHERE OBJECT_ID = '" + sourceId + "';";
        Query query = entityManager.createNativeQuery(sqlStatement);
        query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NewsArticlesUpgrade.java", NewsArticlesUpgrade.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setArticleMetadatasItems", "org.exoplatform.news.upgrade.jcr.NewsArticlesUpgrade", "java.lang.String:java.lang.String", "targetId:sourceId", "javax.jcr.RepositoryException", "void"), 660);
    }
}

