/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.notification.plugin;

import io.meeds.news.notification.plugin.PostNewsNotificationPlugin;
import io.meeds.news.notification.utils.NotificationConstants;
import io.meeds.news.notification.utils.NotificationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.notification.Utils;

public class MentionInNewsNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(MentionInNewsNotificationPlugin.class);
    public static final String ID = "MentionInNewsNotificationPlugin";
    public static final Pattern MENTION_PATTERN = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    public static final ArgumentLiteral<Set> MENTIONED_IDS = new ArgumentLiteral(Set.class, "MENTIONED_IDS");
    public static final ArgumentLiteral<NotificationConstants.NOTIFICATION_CONTEXT> CONTEXT = new ArgumentLiteral(NotificationConstants.NOTIFICATION_CONTEXT.class, "CONTEXT");

    public MentionInNewsNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        String currentUserName;
        NotificationConstants.NOTIFICATION_CONTEXT context = (NotificationConstants.NOTIFICATION_CONTEXT)((Object)ctx.value(CONTEXT));
        String currentUserFullName = currentUserName = (String)ctx.value(PostNewsNotificationPlugin.CURRENT_USER);
        try {
            currentUserFullName = NotificationUtils.getUserFullName(currentUserName);
        }
        catch (Exception e) {
            LOG.error((Object)("An error occured when trying to retreive a user with username " + currentUserName + " " + e.getMessage()), (Throwable)e);
        }
        String contentSpaceId = (String)ctx.value(PostNewsNotificationPlugin.CONTENT_SPACE_ID);
        String contentAuthor = (String)ctx.value(PostNewsNotificationPlugin.CONTENT_AUTHOR);
        String contentSpaceName = (String)ctx.value(PostNewsNotificationPlugin.CONTENT_SPACE);
        ArrayList mentionedIds = new ArrayList((Collection)ctx.value(MENTIONED_IDS));
        String newsTitle = (String)ctx.value(PostNewsNotificationPlugin.CONTENT_TITLE);
        String illustrationUrl = (String)ctx.value(PostNewsNotificationPlugin.ILLUSTRATION_URL);
        String authorAvatarUrl = (String)ctx.value(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL);
        String activityLink = (String)ctx.value(PostNewsNotificationPlugin.ACTIVITY_LINK);
        String newsId = (String)ctx.value(PostNewsNotificationPlugin.NEWS_ID);
        HashSet receivers = new HashSet();
        String[] mentionnedIdArray = new String[mentionedIds.size()];
        Utils.sendToMentioners(receivers, (String[])mentionedIds.toArray(mentionnedIdArray), (String)currentUserName, (String)contentSpaceId);
        return NotificationInfo.instance().setFrom(currentUserName).setSpaceId(Long.parseLong(contentSpaceId)).to(new ArrayList(receivers)).key(this.getKey()).with("CONTENT_TITLE", newsTitle).with("CONTENT_AUTHOR", contentAuthor).with("CURRENT_USER", currentUserFullName).with("CONTENT_SPACE", contentSpaceName).with("ILLUSTRATION_URL", illustrationUrl).with("AUTHOR_AVATAR_URL", authorAvatarUrl).with("ACTIVITY_LINK", activityLink).with("CONTEXT", context.getContext()).with("MENTIONED_IDS", String.valueOf(mentionedIds)).with("NEWS_ID", newsId).end();
    }
}

