/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.ModelConfigContainer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetModelResponse
implements JsonpSerializable {
    private final List<ModelConfigContainer> models;
    public static final JsonpDeserializer<GetModelResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetModelResponse::setupGetModelResponseDeserializer);

    private GetModelResponse(Builder builder) {
        this.models = ApiTypeHelper.unmodifiableRequired(builder.models, (Object)this, "models");
    }

    public static GetModelResponse of(Function<Builder, ObjectBuilder<GetModelResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ModelConfigContainer> models() {
        return this.models;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.models)) {
            generator.writeKey("models");
            generator.writeStartArray();
            for (ModelConfigContainer item0 : this.models) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetModelResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::models, JsonpDeserializer.arrayDeserializer(ModelConfigContainer._DESERIALIZER), "models");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetModelResponse> {
        private List<ModelConfigContainer> models;

        public final Builder models(List<ModelConfigContainer> list) {
            this.models = Builder._listAddAll(this.models, list);
            return this;
        }

        public final Builder models(ModelConfigContainer value, ModelConfigContainer ... values) {
            this.models = Builder._listAdd(this.models, value, values);
            return this;
        }

        public final Builder models(Function<ModelConfigContainer.Builder, ObjectBuilder<ModelConfigContainer>> fn) {
            return this.models(fn.apply(new ModelConfigContainer.Builder()).build(), new ModelConfigContainer[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetModelResponse build() {
            this._checkSingleUse();
            return new GetModelResponse(this);
        }
    }
}

