/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayToStringFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.SelfRenderingOrderedSetAggregateFunctionSqlAstExpression;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class H2ArrayToStringFunction
extends ArrayToStringFunction {
    private final int maximumArraySize;

    public H2ArrayToStringFunction(int maximumArraySize, TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
        this.maximumArraySize = maximumArraySize;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        boolean needsCast;
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression separatorExpression = (Expression)sqlAstArguments.get(1);
        Expression defaultExpression = sqlAstArguments.size() > 2 ? (Expression)sqlAstArguments.get(2) : null;
        BasicPluralType pluralType = (BasicPluralType)arrayExpression.getExpressionType().getSingleJdbcMapping();
        int ddlTypeCode = pluralType.getElementType().getJdbcType().getDdlTypeCode();
        boolean bl = needsCast = !SqlTypes.isStringType(ddlTypeCode);
        if (arrayExpression instanceof SelfRenderingOrderedSetAggregateFunctionSqlAstExpression && "array_agg".equals(((FunctionExpression)arrayExpression).getFunctionName())) {
            SelfRenderingOrderedSetAggregateFunctionSqlAstExpression functionExpression = (SelfRenderingOrderedSetAggregateFunctionSqlAstExpression)arrayExpression;
            Expression arrayElementExpression = (Expression)functionExpression.getArguments().get(0);
            List<SortSpecification> withinGroup = functionExpression.getWithinGroup();
            Predicate filter = functionExpression.getFilter();
            sqlAppender.append("listagg(");
            if (defaultExpression != null) {
                sqlAppender.append("coalesce(");
            }
            if (needsCast) {
                if (ddlTypeCode == 16) {
                    sqlAppender.append("lower(");
                }
                sqlAppender.append("cast(");
            }
            arrayElementExpression.accept(walker);
            if (needsCast) {
                sqlAppender.append(" as varchar)");
                if (ddlTypeCode == 16) {
                    sqlAppender.append(')');
                }
            }
            if (defaultExpression != null) {
                sqlAppender.append(',');
                defaultExpression.accept(walker);
                sqlAppender.append(')');
            }
            sqlAppender.append(",");
            walker.render(separatorExpression, SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(')');
            if (withinGroup != null && !withinGroup.isEmpty()) {
                walker.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
                sqlAppender.appendSql(" within group (order by ");
                withinGroup.get(0).accept(walker);
                for (int i = 1; i < withinGroup.size(); ++i) {
                    sqlAppender.appendSql(',');
                    withinGroup.get(i).accept(walker);
                }
                sqlAppender.appendSql(')');
                walker.getCurrentClauseStack().pop();
            }
            if (filter != null) {
                walker.getCurrentClauseStack().push(Clause.WHERE);
                sqlAppender.appendSql(" filter (where ");
                filter.accept(walker);
                sqlAppender.appendSql(')');
                walker.getCurrentClauseStack().pop();
            }
        } else {
            sqlAppender.append("case when ");
            arrayExpression.accept(walker);
            sqlAppender.append(" is not null then coalesce((select listagg(");
            if (defaultExpression != null) {
                sqlAppender.append("coalesce(");
            }
            if (needsCast) {
                if (ddlTypeCode == 16) {
                    sqlAppender.append("lower(");
                }
                sqlAppender.append("cast(");
            }
            sqlAppender.append("array_get(");
            arrayExpression.accept(walker);
            sqlAppender.append(",i.idx)");
            if (needsCast) {
                sqlAppender.append(" as varchar)");
                if (ddlTypeCode == 16) {
                    sqlAppender.append(')');
                }
            }
            if (defaultExpression != null) {
                sqlAppender.append(',');
                defaultExpression.accept(walker);
                sqlAppender.append(')');
            }
            sqlAppender.append(",");
            walker.render(separatorExpression, SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.append(") within group (order by i.idx) from system_range(1,");
            sqlAppender.append(Integer.toString(this.maximumArraySize));
            sqlAppender.append(") i(idx) where i.idx<=coalesce(cardinality(");
            arrayExpression.accept(walker);
            sqlAppender.append("),0)),'') end");
        }
    }
}

