/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest.model;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;

public class RealizationValidityContext
implements Cloneable {
    private boolean validIdentity = true;
    private boolean validProgram = true;
    private boolean validAudience = true;
    private boolean validRule = true;
    private boolean validDates = true;
    private boolean validRecurrence = true;
    private boolean validWhitelist = true;
    private Map<String, Boolean> validPrerequisites = null;
    private long nextOccurenceMillis = 0L;

    public boolean isValidForIdentity() {
        return this.validIdentity && this.isValid();
    }

    public boolean isValid() {
        return this.isValidNoPrerequisites() && this.isValidPrerequisites();
    }

    public boolean isValidButLocked() {
        return this.isValidNoPrerequisites() && !this.isValidPrerequisites();
    }

    private boolean isValidPrerequisites() {
        return MapUtils.isEmpty(this.validPrerequisites) || this.validPrerequisites.values().stream().allMatch(Boolean::booleanValue);
    }

    public boolean isValidNoPrerequisites() {
        return this.validProgram && this.validAudience && this.validRule && this.validDates && this.validRecurrence && this.validWhitelist;
    }

    protected RealizationValidityContext clone() {
        return new RealizationValidityContext(this.validIdentity, this.validProgram, this.validAudience, this.validRule, this.validDates, this.validRecurrence, this.validWhitelist, this.validPrerequisites, this.nextOccurenceMillis);
    }

    @Generated
    public RealizationValidityContext(boolean validIdentity, boolean validProgram, boolean validAudience, boolean validRule, boolean validDates, boolean validRecurrence, boolean validWhitelist, Map<String, Boolean> validPrerequisites, long nextOccurenceMillis) {
        this.validIdentity = validIdentity;
        this.validProgram = validProgram;
        this.validAudience = validAudience;
        this.validRule = validRule;
        this.validDates = validDates;
        this.validRecurrence = validRecurrence;
        this.validWhitelist = validWhitelist;
        this.validPrerequisites = validPrerequisites;
        this.nextOccurenceMillis = nextOccurenceMillis;
    }

    @Generated
    public RealizationValidityContext() {
    }

    @Generated
    public boolean isValidIdentity() {
        return this.validIdentity;
    }

    @Generated
    public boolean isValidProgram() {
        return this.validProgram;
    }

    @Generated
    public boolean isValidAudience() {
        return this.validAudience;
    }

    @Generated
    public boolean isValidRule() {
        return this.validRule;
    }

    @Generated
    public boolean isValidDates() {
        return this.validDates;
    }

    @Generated
    public boolean isValidRecurrence() {
        return this.validRecurrence;
    }

    @Generated
    public boolean isValidWhitelist() {
        return this.validWhitelist;
    }

    @Generated
    public Map<String, Boolean> getValidPrerequisites() {
        return this.validPrerequisites;
    }

    @Generated
    public long getNextOccurenceMillis() {
        return this.nextOccurenceMillis;
    }

    @Generated
    public void setValidIdentity(boolean validIdentity) {
        this.validIdentity = validIdentity;
    }

    @Generated
    public void setValidProgram(boolean validProgram) {
        this.validProgram = validProgram;
    }

    @Generated
    public void setValidAudience(boolean validAudience) {
        this.validAudience = validAudience;
    }

    @Generated
    public void setValidRule(boolean validRule) {
        this.validRule = validRule;
    }

    @Generated
    public void setValidDates(boolean validDates) {
        this.validDates = validDates;
    }

    @Generated
    public void setValidRecurrence(boolean validRecurrence) {
        this.validRecurrence = validRecurrence;
    }

    @Generated
    public void setValidWhitelist(boolean validWhitelist) {
        this.validWhitelist = validWhitelist;
    }

    @Generated
    public void setValidPrerequisites(Map<String, Boolean> validPrerequisites) {
        this.validPrerequisites = validPrerequisites;
    }

    @Generated
    public void setNextOccurenceMillis(long nextOccurenceMillis) {
        this.nextOccurenceMillis = nextOccurenceMillis;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealizationValidityContext)) {
            return false;
        }
        RealizationValidityContext other = (RealizationValidityContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValidIdentity() != other.isValidIdentity()) {
            return false;
        }
        if (this.isValidProgram() != other.isValidProgram()) {
            return false;
        }
        if (this.isValidAudience() != other.isValidAudience()) {
            return false;
        }
        if (this.isValidRule() != other.isValidRule()) {
            return false;
        }
        if (this.isValidDates() != other.isValidDates()) {
            return false;
        }
        if (this.isValidRecurrence() != other.isValidRecurrence()) {
            return false;
        }
        if (this.isValidWhitelist() != other.isValidWhitelist()) {
            return false;
        }
        if (this.getNextOccurenceMillis() != other.getNextOccurenceMillis()) {
            return false;
        }
        Map<String, Boolean> this$validPrerequisites = this.getValidPrerequisites();
        Map<String, Boolean> other$validPrerequisites = other.getValidPrerequisites();
        return !(this$validPrerequisites == null ? other$validPrerequisites != null : !((Object)this$validPrerequisites).equals(other$validPrerequisites));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RealizationValidityContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValidIdentity() ? 79 : 97);
        result = result * 59 + (this.isValidProgram() ? 79 : 97);
        result = result * 59 + (this.isValidAudience() ? 79 : 97);
        result = result * 59 + (this.isValidRule() ? 79 : 97);
        result = result * 59 + (this.isValidDates() ? 79 : 97);
        result = result * 59 + (this.isValidRecurrence() ? 79 : 97);
        result = result * 59 + (this.isValidWhitelist() ? 79 : 97);
        long $nextOccurenceMillis = this.getNextOccurenceMillis();
        result = result * 59 + (int)($nextOccurenceMillis >>> 32 ^ $nextOccurenceMillis);
        Map<String, Boolean> $validPrerequisites = this.getValidPrerequisites();
        result = result * 59 + ($validPrerequisites == null ? 43 : ((Object)$validPrerequisites).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RealizationValidityContext(validIdentity=" + this.isValidIdentity() + ", validProgram=" + this.isValidProgram() + ", validAudience=" + this.isValidAudience() + ", validRule=" + this.isValidRule() + ", validDates=" + this.isValidDates() + ", validRecurrence=" + this.isValidRecurrence() + ", validWhitelist=" + this.isValidWhitelist() + ", validPrerequisites=" + String.valueOf(this.getValidPrerequisites()) + ", nextOccurenceMillis=" + this.getNextOccurenceMillis() + ")";
    }
}

