/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

final class PathIteratorAdapter
implements PathIterator {
    private final AffineTransform at;
    private final Iterator<CoordinateSequence> sequences;
    private CoordinateSequence coordinates;
    private int pointCount;
    private int closingPoint;
    private int currentIndex;

    PathIteratorAdapter(Geometry geometry, AffineTransform affineTransform) {
        this.at = affineTransform != null ? affineTransform : new AffineTransform();
        this.sequences = PathIteratorAdapter.iterator(geometry);
        this.nextSequence();
    }

    private void nextSequence() {
        while (this.sequences.hasNext()) {
            this.coordinates = this.sequences.next();
            this.pointCount = this.coordinates.size();
            this.closingPoint = this.pointCount - 1;
            if (this.closingPoint < 1 || !this.coordinates.getCoordinate(0).equals2D(this.coordinates.getCoordinate(this.closingPoint))) {
                this.closingPoint = -1;
            }
            if (this.pointCount <= 0) continue;
            return;
        }
    }

    @Override
    public void next() {
        if (++this.currentIndex >= this.pointCount) {
            this.currentIndex = 0;
            this.coordinates = null;
            this.nextSequence();
        }
    }

    @Override
    public boolean isDone() {
        return this.coordinates == null;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public int currentSegment(double[] dArray) {
        if (this.currentIndex == this.closingPoint) {
            return 4;
        }
        dArray[0] = this.coordinates.getX(this.currentIndex);
        dArray[1] = this.coordinates.getY(this.currentIndex);
        this.at.transform(dArray, 0, dArray, 0, 1);
        return this.currentIndex == 0 ? 0 : 1;
    }

    @Override
    public int currentSegment(float[] fArray) {
        if (this.currentIndex == this.closingPoint) {
            return 4;
        }
        fArray[0] = (float)this.coordinates.getX(this.currentIndex);
        fArray[1] = (float)this.coordinates.getY(this.currentIndex);
        this.at.transform(fArray, 0, fArray, 0, 1);
        return this.currentIndex == 0 ? 0 : 1;
    }

    private static Iterator<CoordinateSequence> iterator(Geometry geometry) {
        Set<CoordinateSequence> set;
        if (geometry instanceof LineString) {
            set = Collections.singleton(((LineString)geometry).getCoordinateSequence());
        } else if (geometry instanceof Point) {
            set = Collections.singleton(((Point)geometry).getCoordinateSequence());
        } else {
            if (geometry instanceof Polygon) {
                return new RingIterator((Polygon)geometry);
            }
            if (geometry instanceof GeometryCollection) {
                return new GeomIterator((GeometryCollection)geometry);
            }
            throw new IllegalArgumentException(Errors.format((short)163, (Object)Classes.getShortClassName((Object)geometry)));
        }
        return set.iterator();
    }

    private static final class RingIterator
    implements Iterator<CoordinateSequence> {
        private final Polygon polygon;
        private int interior;

        RingIterator(Polygon polygon) {
            this.polygon = polygon;
            this.interior = -1;
        }

        @Override
        public boolean hasNext() {
            return this.interior < this.polygon.getNumInteriorRing();
        }

        @Override
        public CoordinateSequence next() {
            LinearRing linearRing = this.interior < 0 ? this.polygon.getExteriorRing() : this.polygon.getInteriorRingN(this.interior);
            ++this.interior;
            return linearRing.getCoordinateSequence();
        }
    }

    private static final class GeomIterator
    implements Iterator<CoordinateSequence> {
        private final GeometryCollection collection;
        private int index;
        private Iterator<CoordinateSequence> current;

        GeomIterator(GeometryCollection geometryCollection) {
            this.collection = geometryCollection;
            while (this.index < geometryCollection.getNumGeometries()) {
                this.current = PathIteratorAdapter.iterator(geometryCollection.getGeometryN(this.index));
                if (this.current.hasNext()) break;
                ++this.index;
            }
        }

        @Override
        public boolean hasNext() {
            while (!this.current.hasNext()) {
                if (++this.index >= this.collection.getNumGeometries()) {
                    return false;
                }
                this.current = PathIteratorAdapter.iterator(this.collection.getGeometryN(this.index));
            }
            return true;
        }

        @Override
        public CoordinateSequence next() {
            return this.current.next();
        }
    }
}

