/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.Buffer;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.RasterFactory;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.RangeArgument;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.HyperRectangleReader;
import org.apache.sis.internal.storage.io.Region;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;

final class RawRasterReader
extends HyperRectangleReader {
    private static final int BIDIMENSIONAL = 2;
    private static final int X_DIMENSION = 0;
    private static final int Y_DIMENSION = 1;
    final GridGeometry gridGeometry;
    final SampleModel layout;
    private final int bandGapBytes;
    private GridGeometry effectiveDomain;

    public RawRasterReader(GridGeometry gridGeometry, SampleModel sampleModel, int n, ChannelDataInput channelDataInput) throws DataStoreContentException {
        super(ImageUtilities.toNumberEnum((int)sampleModel.getDataType()), channelDataInput);
        this.gridGeometry = gridGeometry;
        this.layout = sampleModel;
        this.bandGapBytes = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WritableRaster read(GridGeometry gridGeometry, RangeArgument rangeArgument) throws DataStoreException, IOException {
        Buffer[] bufferArray;
        Object object;
        int[] nArray;
        int n;
        int n2;
        int n3;
        SampleModel sampleModel;
        int n4 = this.layout.getWidth();
        int n5 = this.layout.getHeight();
        if (this.layout instanceof ComponentSampleModel) {
            sampleModel = (ComponentSampleModel)this.layout;
            n3 = ((ComponentSampleModel)sampleModel).getScanlineStride();
            n2 = ((ComponentSampleModel)sampleModel).getPixelStride();
            n = 1;
        } else {
            sampleModel = (MultiPixelPackedSampleModel)this.layout;
            n3 = ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride();
            n2 = ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride();
            n = DataBuffer.getDataTypeSize(this.layout.getDataType());
        }
        long[] lArray = new long[]{n3, n5};
        long[] lArray2 = new long[2];
        long[] lArray3 = (long[])lArray.clone();
        if (gridGeometry == null) {
            gridGeometry = this.gridGeometry;
            nArray = new int[]{1, 1};
        } else {
            int n6 = 0;
            GridDerivation gridDerivation = this.gridGeometry.derive();
            if (n > 1) {
                gridDerivation.chunkSize(new int[]{n / n2});
            }
            if (n2 != n) {
                gridDerivation.maximumSubsampling(new int[]{1});
            }
            if (this.layout.getClass() == ComponentSampleModel.class) {
                n6 = 1;
                gridDerivation.chunkSize(new int[]{n3});
                gridDerivation.maximumSubsampling(new int[]{1});
            }
            GridExtent gridExtent = gridDerivation.subgrid(gridGeometry).getIntersection();
            for (int i = n6; i < 2; ++i) {
                lArray2[i] = gridExtent.getLow(i);
                lArray3[i] = Math.incrementExact(gridExtent.getHigh(i));
            }
            if (0 >= n6) {
                lArray2[0] = Math.floorDiv(Math.multiplyExact(lArray2[0], (long)n2), (long)n);
                lArray3[0] = Numerics.ceilDiv((long)Math.multiplyExact(lArray3[0], (long)n2), (long)n);
            }
            nArray = gridDerivation.getSubsampling();
            gridGeometry = gridDerivation.build();
        }
        Region region = new Region(lArray, lArray2, lArray3, nArray);
        int n7 = region.getTargetSize(0);
        int n8 = region.getTargetSize(1);
        SampleModel sampleModel2 = this.layout;
        boolean bl = rangeArgument.isIdentity();
        if (this.layout instanceof BandedSampleModel) {
            object = (BandedSampleModel)this.layout;
            if (!ArraysExt.allEquals((int[])((ComponentSampleModel)object).getBandOffsets(), (int)0) && ArraysExt.isRange((int)0, (int[])((ComponentSampleModel)object).getBankIndices())) {
                throw new DataStoreException("Not yet supported.");
            }
            int n9 = rangeArgument.getNumBands();
            int[] nArray2 = ArraysExt.range((int)0, (int)n9);
            int[] nArray3 = new int[n9];
            long l = Math.addExact(JDK9.multiplyFull((int)n4, (int)n5), (long)this.bandGapBytes);
            long l2 = this.getOrigin();
            bufferArray = new Buffer[n9];
            try {
                for (int i = 0; i < n9; ++i) {
                    int n10 = rangeArgument.getSourceIndex(i);
                    this.setOrigin(Math.addExact(l2, Math.multiplyExact(l, (long)n10)));
                    bufferArray[rangeArgument.getTargetIndex((int)i)] = this.readAsBuffer(region, 0);
                }
            }
            finally {
                this.setOrigin(l2);
            }
            if (!bl) {
                sampleModel2 = new BandedSampleModel(((SampleModel)object).getDataType(), n4, n5, n3, nArray2, nArray3);
                bl = true;
            }
        } else {
            bufferArray = new Buffer[]{this.readAsBuffer(region, 0)};
            n7 = Numerics.wholeDiv((int)n7, (int)sampleModel2.getNumBands());
        }
        if (n7 != n4 || n8 != n5) {
            sampleModel2 = sampleModel2.createCompatibleSampleModel(n7, n8);
        }
        object = RasterFactory.wrap((DataType)DataType.forDataBufferType((int)sampleModel2.getDataType()), (Buffer[])bufferArray);
        WritableRaster writableRaster = WritableRaster.createWritableRaster(sampleModel2, (DataBuffer)object, null);
        if (!bl) {
            writableRaster = writableRaster.createWritableChild(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, rangeArgument.getSelectedBands());
        }
        this.effectiveDomain = gridGeometry;
        return writableRaster;
    }

    final GridGeometry getEffectiveDomain() {
        GridGeometry gridGeometry = this.effectiveDomain;
        this.effectiveDomain = null;
        return gridGeometry;
    }
}

