/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.io.Serializable;
import java.text.CharacterIterator;
import org.apache.sis.util.ArgumentChecks;

public class SimpleCharacterIterator
implements CharacterIterator,
CharSequence,
Serializable {
    private static final long serialVersionUID = 4211374670559434445L;
    protected final CharSequence text;
    protected static final int lower = 0;
    protected int upper;
    private int index;

    public SimpleCharacterIterator(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("text", charSequence);
        this.text = charSequence;
        this.upper = charSequence.length();
    }

    @Override
    public final char first() {
        if (this.upper == 0) {
            return '\uffff';
        }
        this.index = 0;
        return this.text.charAt(0);
    }

    @Override
    public final char last() {
        if (this.upper == 0) {
            return '\uffff';
        }
        this.index = this.upper - 1;
        return this.text.charAt(this.index);
    }

    @Override
    public final char current() {
        return this.index != this.upper ? this.text.charAt(this.index) : (char)'\uffff';
    }

    @Override
    public final char next() {
        if (++this.index < this.upper) {
            return this.text.charAt(this.index);
        }
        this.index = this.upper;
        return '\uffff';
    }

    @Override
    public final char previous() {
        if (--this.index >= 0) {
            return this.text.charAt(this.index);
        }
        this.index = 0;
        return '\uffff';
    }

    @Override
    public final char charAt(int n) {
        return this.text.charAt(n);
    }

    @Override
    public final char setIndex(int n) {
        ArgumentChecks.ensureBetween("position", 0, this.upper, n);
        this.index = n;
        return this.index != this.upper ? this.text.charAt(n) : (char)'\uffff';
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final int getBeginIndex() {
        return 0;
    }

    @Override
    public final int getEndIndex() {
        return this.upper;
    }

    @Override
    public final int length() {
        return this.upper - 0;
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        return this.text.subSequence(n, n2);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    @Override
    public final String toString() {
        return this.text.subSequence(0, this.upper).toString();
    }
}

