/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_data_lifecycle_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataStreamStats
implements JsonpSerializable {
    private final int backingIndicesInError;
    private final int backingIndicesInTotal;
    private final String name;
    public static final JsonpDeserializer<DataStreamStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamStats::setupDataStreamStatsDeserializer);

    private DataStreamStats(Builder builder) {
        this.backingIndicesInError = ApiTypeHelper.requireNonNull(builder.backingIndicesInError, (Object)this, "backingIndicesInError", 0);
        this.backingIndicesInTotal = ApiTypeHelper.requireNonNull(builder.backingIndicesInTotal, (Object)this, "backingIndicesInTotal", 0);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static DataStreamStats of(Function<Builder, ObjectBuilder<DataStreamStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int backingIndicesInError() {
        return this.backingIndicesInError;
    }

    public final int backingIndicesInTotal() {
        return this.backingIndicesInTotal;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("backing_indices_in_error");
        generator.write(this.backingIndicesInError);
        generator.writeKey("backing_indices_in_total");
        generator.write(this.backingIndicesInTotal);
        generator.writeKey("name");
        generator.write(this.name);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backingIndicesInError, JsonpDeserializer.integerDeserializer(), "backing_indices_in_error");
        op.add(Builder::backingIndicesInTotal, JsonpDeserializer.integerDeserializer(), "backing_indices_in_total");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamStats> {
        private Integer backingIndicesInError;
        private Integer backingIndicesInTotal;
        private String name;

        public final Builder backingIndicesInError(int value) {
            this.backingIndicesInError = value;
            return this;
        }

        public final Builder backingIndicesInTotal(int value) {
            this.backingIndicesInTotal = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamStats build() {
            this._checkSingleUse();
            return new DataStreamStats(this);
        }
    }
}

