/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.StreamValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public class FilePersistedValueData
extends StreamValueData
implements PersistedValueData {
    protected File file;

    public FilePersistedValueData() throws IOException {
        this(0, null, SpoolConfig.getDefaultSpoolConfig());
    }

    public FilePersistedValueData(int orderNumber, File file, SpoolConfig spoolConfig) throws IOException {
        super(orderNumber, null, null, spoolConfig);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public InputStream getAsStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public byte[] getAsByteArray() throws IllegalStateException, IOException {
        return this.fileToByteArray(this.file);
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public boolean isByteArray() {
        return false;
    }

    @Override
    public long read(OutputStream stream, long length, long position) throws IOException {
        return this.readFromFile(stream, this.file, length, position);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderNumber = in.readInt();
        int size = in.readInt();
        if (size > 0) {
            byte[] buf = new byte[size];
            in.readFully(buf);
            File f = new File(new String(buf, "UTF-8"));
            this.file = f.exists() ? f : null;
        } else {
            this.file = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.orderNumber);
        if (this.file != null) {
            byte[] buf = this.file.getCanonicalPath().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        } else {
            out.writeInt(0);
        }
    }

    @Override
    protected boolean internalEquals(ValueData another) {
        if (another instanceof FilePersistedValueData) {
            return this.file.equals(((FilePersistedValueData)another).file);
        }
        return false;
    }

    @Override
    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new FilePersistedValueData(orderNumber, this.file, this.spoolConfig);
    }
}

