/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.jakarta;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.config.ConfigParser;
import org.apache.commons.chain.impl.CatalogBase;
import org.apache.commons.chain.web.CheckedConsumer;
import org.apache.commons.chain.web.jakarta.ChainResources;
import org.apache.commons.digester.RuleSet;
import org.slf4j.Logger;

final class ChainInit {
    static final String CONFIG_ATTR = "org.apache.commons.chain.CONFIG_ATTR";
    static final String CONFIG_CLASS_RESOURCE = "org.apache.commons.chain.CONFIG_CLASS_RESOURCE";
    static final String CONFIG_WEB_RESOURCE = "org.apache.commons.chain.CONFIG_WEB_RESOURCE";
    static final String RULE_SET = "org.apache.commons.chain.RULE_SET";

    static void destroy(ServletContext context, String attr) {
        if (attr != null) {
            context.removeAttribute(attr);
        }
        CatalogFactory.clear();
    }

    private ChainInit() {
    }

    static void initialize(ServletContext context, String attr, Logger logger, boolean parseJarResources) throws ServletException {
        CheckedConsumer parse;
        String classResources = context.getInitParameter(CONFIG_CLASS_RESOURCE);
        String ruleSet = context.getInitParameter(RULE_SET);
        String webResources = context.getInitParameter(CONFIG_WEB_RESOURCE);
        Catalog catalog = null;
        if (attr != null && (catalog = (Catalog)context.getAttribute(attr)) == null) {
            catalog = new CatalogBase();
        }
        ConfigParser parser = new ConfigParser();
        if (ruleSet != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = ChainInit.class.getClassLoader();
                }
                Class<RuleSet> clazz = loader.loadClass(ruleSet).asSubclass(RuleSet.class);
                parser.setRuleSet(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new ServletException("Exception initalizing RuleSet '" + ruleSet + "' instance ", (Throwable)e);
            }
        }
        if (attr == null) {
            parse = arg_0 -> ((ConfigParser)parser).parse(arg_0);
        } else {
            Catalog cat = catalog;
            parse = url -> parser.parse(cat, url);
        }
        if (parseJarResources) {
            ChainInit.parseJarResources(context, parse, logger);
        }
        ChainResources.parseClassResources(classResources, parse);
        ChainResources.parseWebResources(context, webResources, parse);
        if (attr != null) {
            context.setAttribute(attr, (Object)catalog);
        }
    }

    private static <E extends Exception> void parseJarResources(ServletContext context, CheckedConsumer<URL, E> parse, Logger logger) {
        Set<String> jars = context.getResourcePaths("/WEB-INF/lib");
        if (jars == null) {
            jars = Collections.emptySet();
        }
        String path22 = null;
        for (String path22 : jars) {
            if (!path22.endsWith(".jar")) continue;
            URL resourceURL = null;
            try {
                URL jarURL = context.getResource(path22);
                path22 = jarURL.toExternalForm();
                resourceURL = new URL("jar:" + ChainInit.translate(path22) + "!/META-INF/chain-config.xml");
                path22 = resourceURL.toExternalForm();
                InputStream is = null;
                try {
                    is = resourceURL.openStream();
                }
                catch (Exception e) {
                    logger.atTrace().setMessage("OpenStream: {}").addArgument((Object)resourceURL).setCause((Throwable)e).log();
                }
                if (is == null) {
                    logger.debug("Not Found: {}", (Object)resourceURL);
                    continue;
                }
                is.close();
                logger.debug("Parsing: {}", (Object)resourceURL);
                parse.accept((Object)resourceURL);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception parsing chain config resource '" + path22 + "': " + e.getMessage());
            }
        }
    }

    private static String translate(String value) {
        int index;
        while ((index = value.indexOf(32)) >= 0) {
            value = value.substring(0, index) + "%20" + value.substring(index + 1);
        }
        return value;
    }
}

